#
# FILE
#   localizers_loaders.tcl
#
# PROTOCOL
#   mri/localizers
#
# DESCRIPTION
#   First pass at fMRI localizer paradigm.
#
# AUTHOR
#   based on shapes_and_saccades by HMS
#   3/24/16 TMD

namespace eval Ephys_Seq {
    ############################################################################
    # Note - for debugging search for set mripath and refreshrate

  proc passive_seq  { monkey  block_order \
		       rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
	set maxtries 100
	for { set tries 0 } { $tries < $maxtries } { incr tries } {
	    if { [catch { try_passive_seq $monkey $block_order \
			      $rwdInt_max $rwdInt_min \
			      $rwdInt_inc $rwdInt_n } ] == 0 } break
	}
	if { $tries == $maxtries } { error "unable to find sequence" }
    }
    

    
  proc try_passive_seq  { monkey  block_order \
		        rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
        
    set numBlocksEachCond 5
    set imgPerBlock 120
    set fixBlockDur 14
    set fixPresent 1 ;#fix spot present for everything
    set bgLuminance 255
    
    #Just to try this out I'm only going to use the scrambled objects for the habituation stim. Can't find whether any fractals live somewhere in folders
    #Only using scramobjects and fixation
    # 0 = Scrambled Objects, 1 = Fixation

    if [file exists c:/stimuli/MRILocalizers] {
        set mripath c:/stimuli/MRILocalizers
    } else {
        set mripath ../stimuli/MRILocalizers
    }

    dl_local imgFolders [eval dl_slist $mripath/scramobjects \
			     fixation]
    
    # Need to add fixation and figure the right way of getting out of dl
    set img_groups [dl_tcllist [dl_filebase $imgFolders]]
    set fixblocknum [lsearch $img_groups "fixation"]

          # Figure out the total number of stim/images that will need of each kind
    set nTotImg [expr $numBlocksEachCond * $imgPerBlock]
            
    # Ok, so let's try to make stimdg exist
    # stimdg
    # ------
    if {[dg_exists stimdg]} {
        dg_delete stimdg
    }

    dg_create stimdg

    dl_set stimdg:version [dl_slist [namespace current]]
 
    dl_set stimdg:block_n [dl_ilist]
    dl_set stimdg:block_id [dl_ilist]
    
    ###Now if block order is 0 then AAAA, if it's 1 then it'll be AAAB. Here 1 is AAAA and 6 is AAAB
    set fixation 0
    #####This piece of code shuffles and creates the block id list. FYI dl_shuffle can also shuffle llists.
    ###Instead of shuffling here, might be better instead to shuffle elsewhere... maybe after lists are created and then shuffle lists. 
    if {$block_order == 0} {
	dl_local habit [dl_ilist 1]
	dl_local deviants [dl_shuffle [dl_ilist 2 3 4 5]]
	set block_type [dl_interleave [dl_combine $habit $deviants] $fixation]
	
    } else {
	dl_local habit [dl_ilist 1]
       	dl_local deviants [dl_shuffle [dl_ilist 2 3 4 5]]
	set block_type [dl_interleave [dl_combine $habit $deviants] $fixation]
    }
    ###Makes the actual total list with the correct number of ids
    for {set i 0} {$i < [dl_llength $block_type]} {incr i} {
	set blocktypeid [dl_get $block_type $i]
	if {$blocktypeid != 0} {
	    dl_set stimdg:block_id [dl_combine stimdg:block_id [dl_repeat $blocktypeid $imgPerBlock]]
	} elseif {$blocktypeid == 0} {
	    dl_set stimdg:block_id [dl_append stimdg:block_id $blocktypeid]
	}
    }
    #####
    set nblocks [expr $numBlocksEachCond*2]
    dl_local block_n [dl_fromto 0 $nblocks]
    dl_local repeat_n \
        [dl_replicate [dl_ilist $imgPerBlock 1] $numBlocksEachCond]
    dl_set stimdg:block_n [dl_repeat $block_n $repeat_n]
    ###Place actual names of each stimtype next to its id
    dl_set stimdg:block_type [dl_repeat [dl_slist null] [dl_llength stimdg:block_id]]
    for {set i 0} {$i < [dl_llength stimdg:block_id]} {incr i} {
	set stimid [lindex [dl_tcllist stimdg:block_id] $i]
	if {$stimid == 1} {
	    if {$block_order == 0} {
		dl_put stimdg:block_type $i "AAAA"
	    } else {
		dl_put stimdg:block_type $i "AAAB"
	    }
	} elseif {$stimid == 2} {
	    dl_put stimdg:block_type $i "Dev1"
	} elseif {$stimid == 3} {
	    dl_put stimdg:block_type $i "Dev2"
	} elseif {$stimid == 4} {
	    dl_put stimdg:block_type $i "Dev3"
	} elseif {$stimid == 5} {
	    dl_put stimdg:block_type $i "Dev4"
	} elseif {$stimid == 0} {
	    dl_put stimdg:block_type $i "fixation"	    
	}; #End of if else
    }; #End of for loop

    
    #######Making the block order########################
    #Call up the images. For stim types, fixation code is 0
    
    set img1 ../stimuli/MRILocalizers/scramobjects/scramobjects_001.png
    set img2 ../stimuli/MRILocalizers/scramobjects/scramobjects_002.png
    set img3 ../stimuli/MRILocalizers/scramobjects/scramobjects_003.png
    set img4 ../stimuli/MRILocalizers/scramobjects/scramobjects_004.png
    set img5 ../stimuli/MRILocalizers/scramobjects/scramobjects_005.png
    set img6 ../stimuli/MRILocalizers/scramobjects/scramobjects_006.png
    set img7 ../stimuli/MRILocalizers/scramobjects/scramobjects_007.png
    
    set uq_block_id [dl_unique stimdg:block_id]
    
    for {set i 0} {$i < [dl_llength $uq_block_id]} {incr i} {
        
        set block_id_idx [dl_get $uq_block_id $i]
        
	if {$block_id_idx == 1} {
	    if {$block_order == 0} {
		set nstim 28
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_repeat "1 2 3 4" 7]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_select "1 2 3 4 21 22 23 24 25 26 27 28" [dl_randchoose 12 6]]]
		set stim_array [dl_repeat 9 $nstim]
	    }
        } elseif {$block_id_idx == 2} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 5 6 7 35 36 37]]
		set stim_array [dl_repeat 9 $nstim]
	    }
	} elseif {$block_id_idx == 3} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 29 30 31 32 33 34]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	} elseif {$block_id_idx == 4} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	    
	} else {
	    if {$block_order == 0} {
	    set nstim 30
            set stim_used [dl_zeros $nstim]
            set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	}
    #Find the next position to fill in
    
        set stim_idx [dl_findAll $stim_array "9"]

    #Go through each idx line individually  
        foreach stimline [dl_tcllist $stim_idx] {
        #First line can be any habituation item
	    if {$stimline == 0} {
            #First stim. Find habit indices
	    #####
	    set habitindices [dl_oneof $poss_stim "1 2 3 4 21 22 23 24 25 26 27 28"]
	    set habit_match [dl_not [dl_and $habitindices [dl_not $stim_used] ] ]
	    #####
            #Find available stimuli
            set avail_stimidxs [dl_findAll $habit_match 0]
	    #set avail_stimidxs [dl_findAll $stim_used 0]
            #Choose randomly one of the available stimuli can use dl_pickone
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            
            dl_put $stim_array $stimline $actual_stim
            #This next put will mark the item in the zeros as used
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
	    #First part logic is sound. Always gives you a new num and marks it where it should be.
	} elseif {[dl_get [dl_oneof $stimline "1 2 3 4 5"] 0] == 1} {
	    set laststim [dl_get $stim_array $lastLine]
	    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]]\
						[dl_not [dl_oneof $poss_stim\
							     "5 6 7 35 36 37 29 30 31 32 33 34\
							     8 10 11 18 19 20 12 13 14 15 16 17"]]] "1"]
	    
	    set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
	    
        } else {
            #Find the available stimuli that are not the previous stimuli
            set laststim [dl_get $stim_array $lastLine]
	    
	    if {$block_order == 0} {
		#If it's stims 1 2 3 4 then it's fine to choose any
		if {[dl_get [dl_oneof $laststim "1 2 3 4"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]] "1"]
		    
		} elseif {[dl_get [dl_oneof $laststim "8 10 11 18 19 20"] 0] == 1} {
		    #Choose so devs don't follow each other (for all other conds)
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "8 10 11 18 19 20"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "5 6 7"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "5 6 7"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "12 13 14 15 16 17"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "12 13 14 15 16 17"]]] "1"]
		}
		
	    } else {
		#Ask to check for last again cause otherwise doesn't find it
		set laststim [dl_get $stim_array $lastLine]
		#Make sure that the ones that start with 1 aren't chosen
		if {[dl_get [dl_oneof $laststim "4 23 26"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
						        [dl_not [dl_oneof $poss_stim "1 2 3"]]] "1"]
		    #Make sure that the ones that start with 2 aren't chosen
		} elseif {[dl_get [dl_oneof $laststim "1 24 27"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "4 21 22"]]] "1"]
		    #Make sure that the ones that start with 3 aren't chosen
		} elseif {[dl_get [dl_oneof $laststim "2 21 28"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "23 24 25"]]] "1"]
		    #Make sure that the ones that start with 4 aren't chosen		    
		} elseif {[dl_get [dl_oneof $laststim "3 22 25"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "26 27 28"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "8 10 11 18 19 20"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "8 10 11 18 19 20"]]] "1"]
		    ##Added these lines because was still getting deviants one after the other
		} elseif {[dl_get [dl_oneof $laststim "5 6 7 35 36 37"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "5 6 7 35 36 37"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "12 13 14 15 16 17"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "12 13 14 15 16 17"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "29 30 31 32 33 34"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "29 30 31 32 33 34"]]] "1"]		    
		} else {
		    set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]] "1"]
		}
	    }

            if {[dl_llength $avail_stimidxs] == 0} {
        #Set list to 0 and pick first stim again
            set stim_used [dl_zeros $nstim]
            set avail_stimidxs [dl_findAll $stim_used 0]
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            dl_put $stim_array $stimline $actual_stim
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
                } else {
                if {[dl_llength $avail_stimidxs] > 1} {
                set chosen_idx [dl_pickone $avail_stimidxs]
                } else {
                set chosen_idx $avail_stimidxs
                }
            }
            
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
        }; #End of if else
        
        }; #End of Foreach
        
        if {$block_id_idx == 1} {
	    if {$block_order == 0} {
	    set first_block $stim_array
	    set laststimidx [dl_not [dl_oneof "1 2 3 4" [dl_last $first_block]]]
	    set first_extra [dl_pickone [dl_select "1 2 3 4" $laststimidx]]
	    set first_extraidx [dl_not [dl_oneof "1 2 3 4" $first_extra]]
	    set both_extra [dl_combine $first_extra [dl_pickone [dl_select \
								     "1 2 3 4" $first_extraidx]]]
	    set first_block [dl_combine $first_block $both_extra]
	    } else {
		set first_block $stim_array
	    }
	    
        } elseif {$block_id_idx == 2} {
	    set dev1_block $stim_array
	} elseif {$block_id_idx == 3} {
	    set dev2_block $stim_array
	} elseif {$block_id_idx == 4} {
	    set dev3_block $stim_array
	} elseif {$block_id_idx == 5} {
	    set dev4_block $stim_array
	}
    }; #End of for loop 
    
    set blockamt 5
    
    for {set i 0} { $i < $blockamt} { incr i} {

        if {$i == 0} {
        set counter 1
        }
        
        
        if {$counter == 1} {
	    set stim_vals $first_block
	    set n_onstim 30
	    set ontime_used [dl_zeros $n_onstim]
	    set poss_ontime [dl_repeat "1 2 3 4 5 6" 5]
	    set time_array [dl_repeat 9 $n_onstim]
	    set time_arrayval [expr [dl_llength $time_array] - 1]
	    set uq_stim [dl_unique $first_block]
	    
        } elseif {$counter == 2} {
            #Number dev
            #Dev times for now will be 7 and 8
            set numdev 1
            set stim_vals $dev1_block
            set n_onstim 30
            set ontime_used [dl_zeros $n_onstim]
            set poss_ontime [dl_concat [dl_repeat "1 2 3 4 5 6" 4] [dl_repeat "7 8" 3]]
            set time_array [dl_repeat 9 $n_onstim]
            set time_arrayval [expr [dl_llength $time_array] - 1]
            set uq_stim [dl_unique $dev1_block]
         
        } elseif {$counter == 3} {
            #New exemplar of same rule
            set numdev 0
            set newexp 1
            set stim_vals $dev2_block
            set n_onstim 30
            set ontime_used [dl_zeros $n_onstim]
            set poss_ontime [dl_concat [dl_repeat "1 2 3 4 5 6" 4] [dl_repeat "10 11" 3]]
            set time_array [dl_repeat 9 $n_onstim]
            set time_arrayval [expr [dl_llength $time_array] - 1]
            set uq_stim [dl_unique $dev2_block]
	    
	} elseif {$counter == 4} {
            #Double dev
            set numdev 1
            set stim_vals $dev3_block
            set n_onstim 30
            set ontime_used [dl_zeros $n_onstim]
            set poss_ontime [dl_concat [dl_repeat "1 2 3 4 5 6" 4] [dl_repeat "7 8" 3]]
            set time_array [dl_repeat 9 $n_onstim]
            set time_arrayval [expr [dl_llength $time_array] - 1]
            set uq_stim [dl_unique $dev3_block]
         
        } elseif {$counter == 5} {
            #Sequence Dev (times are medium times for all items)
            set numdev 0
            set newexp 1
            set stim_vals $dev4_block
            set n_onstim 30
            set ontime_used [dl_zeros $n_onstim]
            set poss_ontime [dl_concat [dl_repeat "1 2 3 4 5 6" 4] [dl_repeat "10 11" 3]]
            set time_array [dl_repeat 9 $n_onstim]
            set time_arrayval [expr [dl_llength $time_array] - 1]
            set uq_stim [dl_unique $dev4_block]     
        }
        
        
        for {set ui 0} {$ui < [dl_llength $uq_stim]} {incr ui} {

             set stim [dl_get $uq_stim $ui]

             #Find the places in the stim_array that have that stim
             set stim_idxs [dl_findAll $stim_vals $stim]
        
             for {set si 0} {$si < [dl_llength $stim_idxs]} {incr si} {

             set stim_idx [dl_get $stim_idxs $si]
             # find all the available ones
             set avail_timeidxs [dl_eq $ontime_used 0]

             # decide avail times based on stim (hab or dev)
             if {[dl_get [dl_oneof $stim "1 2 3 4 21 22 23 24 25 26 27 28"] 0] == 1} {
                 set avail_times [dl_and [dl_eq $avail_timeidxs 1]\
                             [dl_eq [dl_oneof $poss_ontime "1 2 3 4 5 6"] 1]]

                 #Next statement is if stim is oneof 5-7 and num deviant (N+) is true, add this later
             } elseif {[dl_get [dl_and [dl_oneof $stim "5 6 7 8 10 11 18 19 20 35 36 37"] [dl_eq $numdev 1]] 0] == 1} {
                 # pick the long or short times (2 stim or 6 stim total)
                 set avail_times [dl_and [dl_eq $avail_timeidxs 1]\
                          [dl_eq [dl_oneof $poss_ontime "7 8"] 1]]
                 
             } elseif {[dl_get [dl_and [dl_oneof $stim "5 6 7 8 10 11 12 13 14 15 16 17 29 30 31 32 33 34"] [dl_eq $newexp 1]] 0] == 1} {
                 set avail_times [dl_and [dl_eq $avail_timeidxs 1]\
                          [dl_eq  [dl_oneof $poss_ontime "10 11"] 1]]
             # else if stim ismember 5-7 and N-
                 # always assign the medium times (4 stim total)
             }

             if {$stim_idx == 0} {
                 #First stim: find the available stimuli, avail times AND not the next one
                 set next_time [dl_get $time_array [expr $stim_idx + 1]]
            
                 # you need a line like this
                 set avail_timeidxs [dl_findAll [dl_and [dl_eq $avail_times 1]\
                            [dl_noteq $poss_ontime $next_time]\
                               ] "1"]
            
             } elseif {$stim_idx == [dl_last $time_arrayval]} {
                 #If it's the last stim
                 #Find available times: Are available AND not the prev time AND not time
                 #assigned to the previous stim of this kind
                 
                 set prev_time [dl_get $time_array [expr $stim_idx - 1]]
                 set prev_timeidxs [dl_get $time_array [dl_get $stim_idxs [expr $si - 1]]]
                       
                 if {$si == 0} {
                 set avail_timeidxs [dl_findAll\
                        [dl_and [dl_eq $avail_times 1]\
                             [dl_noteq $poss_ontime $prev_time]] "1"]
            
                 set chosen_idx [dl_pickone $avail_timeidxs]
                 } else {
            
                 set avail_timeidxs [dl_findAll\
                        [dl_and [dl_eq $avail_times 1]\
                             [dl_and [dl_noteq $poss_ontime $prev_time]\
                              [dl_noteq $poss_ontime $prev_timeidxs]\
                             ]] "1"]
                
                 }
                 if  {[dl_llength $avail_timeidxs] > 1} {
                 set chosen_idx [dl_pickone $avail_timeidxs]
                 } else {
                 set chosen_idx $avail_timeidxs
                 }
                 
             } else {
            
                 if {$si == 0} {
                 set prev_time [dl_get $time_array [expr $stim_idx - 1]]
                 set next_time [dl_get $time_array [expr $stim_idx + 1]]
            #No previous stim to check
                 set avail_timeidxs [dl_findAll [dl_and [dl_eq $avail_times 1]\
                                [dl_and [dl_noteq $poss_ontime $prev_time]\
                                 [dl_noteq $poss_ontime $next_time]]] "1"]
                 } else {
            
                 set prev_time [dl_get $time_array [expr $stim_idx - 1]]
                 set next_time [dl_get $time_array [expr $stim_idx + 1]]
                 set prev_timeidxs [dl_get $time_array [dl_get $stim_idxs [expr $si - 1]]]
            
                 set avail_timeidxs [dl_findAll [dl_and [dl_eq $avail_times 1]\
                                [dl_and [dl_noteq $poss_ontime $prev_time]\
                                 [dl_and [dl_noteq $poss_ontime $next_time]\
                                      [dl_noteq $poss_ontime $prev_timeidxs]]]] "1"]
         
	     }
                 if {[dl_llength $avail_timeidxs] > 1} {
                 set chosen_idx [dl_pickone $avail_timeidxs]
                 } elseif {[dl_llength $avail_timeidxs] == 1} {
                 set chosen_idx [dl_get $avail_timeidxs 0]
                 }
                 
             }
        
             set chosen_idx [dl_pickone $avail_timeidxs]
             set actual_time [dl_get $poss_ontime $chosen_idx]
             dl_put $time_array $stim_idx $actual_time
             dl_put $ontime_used $chosen_idx 1
             }; #End of si for loop
         }; #End of ui for loop
        
        if {$counter == 1} {
        set first_block_times $time_array
        
        } elseif {$counter == 2} {
        set dev1_block_times $time_array
        
        } elseif {$counter == 3} {
        set dev2_block_times $time_array
        
        } elseif {$counter == 4} {
        set dev3_block_times $time_array
        
        } elseif {$counter == 5} {
        set dev4_block_times $time_array
        
        }
	
        set counter [expr $counter+1]
    }; #End of other for loop
    
    ######Expanding each list to set them on stimdg##########
    ####Expand for stim type list
    #Expanded habit block AAAA
    if {$block_order == 0} {
	#This is for AAAA habit type seq
	set exphabit [dl_append [dl_repeat $first_block 4] 0]
	set exphabittimes [dl_append [dl_repeat $first_block_times 4] 0]
	#Expand dev 1/ second_block and use the same for the times, do the same for dev3
	###This gets it done for the image list 
	set dev1_time_rep [dl_repeat "9" [dl_llength $dev1_block_times]]

	for {set i 0} {$i < [dl_llength $dev1_block_times]} {incr i} {
	    set timeval [lindex [dl_tcllist $dev1_block_times] $i]
	    if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
		dl_put $dev1_time_rep $i 4
	    } elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
	    dl_put $dev1_time_rep $i 2
	    } elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
		dl_put $dev1_time_rep $i 6
	    }
	}
	set expdev1times [dl_append [dl_repeat $dev1_block_times $dev1_time_rep] 0]
            
	set expdev1 [dl_append [dl_repeat $dev1_block $dev1_time_rep] 0]
    
	set dev3_time_rep [dl_repeat "9" [dl_llength $dev3_block_times]]

	for {set i 0} {$i < [dl_llength $dev3_block_times]} {incr i} {
	    set timeval [lindex [dl_tcllist $dev3_block_times] $i]
	    if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
		dl_put $dev3_time_rep $i 4
	    } elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
		dl_put $dev3_time_rep $i 2
	    } elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
		dl_put $dev3_time_rep $i 6
	    }
	}
    
	set expdev3times [dl_append [dl_repeat $dev3_block_times $dev3_time_rep] 0]
            
	set expdev3 [dl_append [dl_repeat $dev3_block $dev3_time_rep] 0]

	#Expand dev 2
	set expdev2 [dl_append [dl_repeat $dev2_block 4] 0]
	set expdev2times [dl_append [dl_repeat $dev2_block_times 4] 0]
	#Aaaand now exp dev4 same way
	set expdev4 [dl_append [dl_repeat $dev4_block 4] 0]
	set expdev4times [dl_append [dl_repeat $dev4_block_times 4] 0]
    } else {
	#This is for AAAB habit type seq
	
	set exphabit [dl_append [dl_repeat $first_block 4] 0]
	set exphabittimes [dl_append [dl_repeat $first_block_times 4] 0]
	#Expand dev 1/ second_block and use the same for the times, do the same for dev3
	###This gets it done for the image list 
	set dev1_time_rep [dl_repeat "9" [dl_llength $dev1_block_times]]

	for {set i 0} {$i < [dl_llength $dev1_block_times]} {incr i} {
	    set timeval [lindex [dl_tcllist $dev1_block_times] $i]
	    if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
		dl_put $dev1_time_rep $i 4
	    } elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
	    dl_put $dev1_time_rep $i 2
	    } elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
		dl_put $dev1_time_rep $i 6
	    }
	}
	set expdev1times [dl_append [dl_repeat $dev1_block_times $dev1_time_rep] 0]
            
	set expdev1 [dl_append [dl_repeat $dev1_block $dev1_time_rep] 0]
    
	set dev3_time_rep [dl_repeat "9" [dl_llength $dev3_block_times]]

	for {set i 0} {$i < [dl_llength $dev3_block_times]} {incr i} {
	    set timeval [lindex [dl_tcllist $dev3_block_times] $i]
	    if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
		dl_put $dev3_time_rep $i 4
	    } elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
		dl_put $dev3_time_rep $i 2
	    } elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
		dl_put $dev3_time_rep $i 6
	    }
	}
    
	set expdev3times [dl_append [dl_repeat $dev3_block_times $dev3_time_rep] 0]
            
	set expdev3 [dl_append [dl_repeat $dev3_block $dev3_time_rep] 0]

	#Expand dev 2
	set expdev2 [dl_append [dl_repeat $dev2_block 4] 0]
	set expdev2times [dl_append [dl_repeat $dev2_block_times 4] 0]
	#Aaaand now exp dev4 same way
	set expdev4 [dl_append [dl_repeat $dev4_block 4] 0]
	set expdev4times [dl_append [dl_repeat $dev4_block_times 4] 0]	
    }
    
    ###Combine lists to get stim_types on stimdg
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id] 
    dl_set stimdg:stim_types [dl_ilist]
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $exphabit]
	} elseif { $idtestvals == 2 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev1]
	} elseif { $idtestvals == 3 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev2]
	} elseif { $idtestvals == 4 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev3]
	} elseif { $idtestvals == 5 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev4]
	}; #end of if else#
    }; #end of foreach

    
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id] 
    dl_set stimdg:on_type [dl_ilist]
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $exphabittimes]
	} elseif { $idtestvals == 2 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev1times]
	} elseif { $idtestvals == 3 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev2times]
	} elseif { $idtestvals == 4 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev3times]
	} elseif { $idtestvals == 5 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev4times]
	}; #end of if else#
    }; #end of foreach
    ###Append the expanded times to ontype stimdg so that they are registered for the totalon_type
                          
    set totalon_type stimdg:on_type
    #So far so good...
      dl_set stimdg:stimcountlist [dl_repeat "9" [dl_llength stimdg:stim_types]]
    set tasktrials [dl_llength stimdg:stim_types]
    
    dl_set stimdg:stimuli [dl_repeat [dl_slist null] $tasktrials]
    
    if {$block_order == 0} {
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
        
	    if {$stimIdx == 1} {
		dl_put stimdg:stimuli $i $img1
	    } elseif {$stimIdx == 2} {
		dl_put stimdg:stimuli $i $img2
	    } elseif {$stimIdx == 3} {
		dl_put stimdg:stimuli $i $img3
	    } elseif {$stimIdx == 4} {
		dl_put stimdg:stimuli $i $img4
	    } elseif {$stimIdx == 5} {
		dl_put stimdg:stimuli $i $img5          
	    } elseif {$stimIdx == 6} {
		dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 7} {
		dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 8} {
		#5-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 10} {
	    #6-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 11} {
		#7-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
		#5-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 19} {
		#6-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 20} {
		#7-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
		dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 13} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 14} {
		if {$imgcount == 4} {        
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}            
	    } elseif {$stimIdx == 15} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 16} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}        
	    } elseif {$stimIdx == 17} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}        
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
        
	}; #End of for loop assigning imgs
    } else {
	
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
	    #Will have individual id for each habit combination
	    
	    if {$stimIdx == 1} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 2} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 3} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 4} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 11} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 21} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img2
		}          
	    } elseif {$stimIdx == 22} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 23} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 24} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 25} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 26} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img4
		}          
	    } elseif {$stimIdx == 27} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 28} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 29} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 30} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 31} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 32} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 33} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}
	    } elseif {$stimIdx == 34} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}		
	    } elseif {$stimIdx == 5} {
		#5-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 6} {
		#5-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 7} {
		#6-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 8} {
	        dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 10} {
		dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 36} {
		#7-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
	        dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 19} {
	        dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 20} {
	        dl_put stimdg:stimuli $i $img7		
	    } elseif {$stimIdx == 35} {
		#6-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 37} {
		#7-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
		dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
	        dl_put stimdg:stimuli $i $img5
		
	    } elseif {$stimIdx == 13} {
		dl_put stimdg:stimuli $i $img5
        
	    } elseif {$stimIdx == 14} {
		dl_put stimdg:stimuli $i $img6
	               
	    } elseif {$stimIdx == 15} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 16} {
		dl_put stimdg:stimuli $i $img7
		       
	    } elseif {$stimIdx == 17} {
		dl_put stimdg:stimuli $i $img7
		      
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
	}; #End of for loop assigning imgs
    }; #End of if else statement
    
    # Figure out how long each frame is based on refresh rate
    # FrameDuration ;# gives answer in *ms*
    set screenHz [screen_set RefreshRate] ;# frames/sec
    # For debugging in tcl
    #set screenHz 60
    
           # Reward
    # ------
    # Grab rewardDuration from the (quick)params
    # set reward_amount 250
    # dl_set stimdg:rewardDuration [dl_repeat $reward_amount $ntrials]

    set ntrials [dl_llength stimdg:block_id]
    dl_set stimdg:rwdInt_max [dl_repeat $rwdInt_max $ntrials]
    dl_set stimdg:rwdInt_min [dl_repeat $rwdInt_min $ntrials]
    dl_set stimdg:rwdInt_inc [dl_repeat $rwdInt_inc $ntrials]
    dl_set stimdg:rwdInt_n [dl_repeat $rwdInt_n $ntrials]

    # Want the fixation spot present for all the trials
    dl_set stimdg:fixPresent [dl_repeat $fixPresent $ntrials]
    dl_set stimdg:background_luminance [dl_repeat $bgLuminance $ntrials]

    ###This is to assign the possible ontimes. This is where we're making the real stimOnDur\
    ###for this task
    ###Set empty stimdg first
    set on_Sec [dl_repeat 0.1 [dl_llength $totalon_type]]
    
        ###Now need to set the stimOffDur
    set off_Sec [dl_repeat 0.1 [dl_llength $totalon_type]]
    dl_set stimdg:offSecIdx [dl_findAll $off_Sec 0.1]
    dl_set stimdg:countlist [dl_repeat "9" [dl_llength $totalon_type]]
    ####Set the last off times to vars that substract from 2.5 (TR is now eq to 2.5)
    
    for {set i 0} { $i < [dl_llength $totalon_type] } { incr i} {

        if {$i == 0} {
        set count 1
        } 
        
        dl_put stimdg:countlist $i $count 
        set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
        set onstimIdx [lindex [dl_tcllist $totalon_type] $i]
        
        if {$onstimIdx == 1} {
        dl_put $on_Sec $i 0.1
        
        if {$count == 4} {
            dl_put $off_Sec $i 1.4
        } else {
            dl_put $off_Sec $i 0.2333
        }
        } elseif {$onstimIdx == 2} {
        dl_put $on_Sec $i 0.2

        if {$count == 4} {
            dl_put $off_Sec $i 1.4
        } else {
            dl_put $off_Sec $i 0.1
        }
        } elseif {$onstimIdx == 3} {
        dl_put $on_Sec $i 0.3
        if {$count == 4} {
            dl_put $off_Sec $i 0.8
        } else {
            dl_put $off_Sec $i 0.1667
        }
        } elseif {$onstimIdx == 4} {
        dl_put $on_Sec $i 0.1
        if {$count == 4} {
            dl_put $off_Sec $i 0.8
        } else {
            dl_put $off_Sec $i 0.4333
        }
        } elseif {$onstimIdx == 5} {
        dl_put $on_Sec $i 0.2
        if {$count == 4} {
            dl_put $off_Sec $i 0.2
        } else {
            dl_put $off_Sec $i 0.5
        }
        } elseif {$onstimIdx == 6} {
        dl_put $on_Sec $i 0.3
        if {$count == 4} {
            dl_put $off_Sec $i 0.2
        } else {
        dl_put $off_Sec $i 0.3667
        }
        } elseif {$onstimIdx == 7} {
        dl_put $on_Sec $i 0.2
        if {$count == 2} {
            dl_put $off_Sec $i 1.4
        } else {
            dl_put $off_Sec $i 0.7
        }
        } elseif {$onstimIdx == 8} {
        dl_put $on_Sec $i 0.2
        if {$count == 6} {
            dl_put $off_Sec $i 0.2
        } else {
            dl_put $off_Sec $i 0.22
        }
        } elseif {$onstimIdx == 10} {
        dl_put $on_Sec $i 0.2
        if {$count == 4} {
            dl_put $off_Sec $i 0.8
        } else {
            dl_put $off_Sec $i 0.3
        }
        } elseif {$onstimIdx == 11} {
        dl_put $on_Sec $i 0.2
        if {$count == 4} {
            dl_put $off_Sec $i 0.8
        } else {
            dl_put $off_Sec $i 0.3
        }
        } elseif {$onstimIdx == 0} {
        dl_put $on_Sec $i 14.0
        }; #end if/else statement
        

        set count [expr $count+1]

        if {$i < [expr [dl_llength $totalon_type]-1]} {
        
            if {[dl_get $totalon_type $i] != [dl_get $totalon_type [expr $i+1]]} {
            set count 1
            }
        }
        

    }; #end for loop
    
    set restofonsec [dl_repeat 0.1 [expr $ntrials - [dl_llength $on_Sec]]]
    
    set stimOnDur [dl_combine $on_Sec $restofonsec]
    dl_set stimdg:on_type $totalon_type

    set restofoffsec [dl_repeat 0.1 [expr $ntrials - [dl_llength $on_Sec]]]
    set stimOffDur [dl_prepend [dl_combine $off_Sec $restofoffsec] 0]
    
    
    
    #### 
    dl_set stimdg:onSec [dl_repeat 0.1 $ntrials]
    dl_set stimdg:offSec [dl_repeat 0.1 $ntrials]
    # Initialize the columns for frame numbers (always integers)
    dl_set stimdg:onFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:offFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:endFrameN [dl_repeat 0 $ntrials]

    for { set i 0 } { $i < $ntrials } { incr i } {
        # Have a choice, can either calculate the times and attempt
        #  to get the frames right, or can calculate the frames, and 
        #  calculate the times accordingly.
        # This is frame-based

        #onSec
        #-----
        if {$i == 0} {
        # First trial
        #dl_put stimdg:onSec $i 0
        dl_put stimdg:onFrameN $i 0
        } else {
        # previous block type
        set prev_block_type [lindex [dl_tcllist stimdg:block_type] \
                     [expr $i - 1]]
        
        # Set the frames, by prev block type
        if { $prev_block_type == "fixation" } {
            set prevOffFrames 0
        } else {
            # round because frames must be integers
            set prevOffFrames [expr round([dl_get $stimOffDur $i] * $screenHz)]
        }

        #onFrameN = previous trial offFrame + 
        #           prevOffFrames (duration in frames)
        dl_put stimdg:onFrameN $i \
            [expr [lindex [dl_tcllist stimdg:offFrameN] [expr $i - 1]] \
             + $prevOffFrames]

        # Also set the previous end frame. 
        #  Repeats info, but keeps the iti explicit
        dl_put stimdg:endFrameN [expr $i - 1] \
            [dl_get stimdg:onFrameN $i]
        }
        # Calculate the corresponding on time in seconds
        dl_put stimdg:onSec $i \
        [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
             / ($screenHz + 0.0)] ;#intro floating point

        #offSec
        #------
        # Get the current block type, fixation or otherwise
        set block_type [lindex [dl_tcllist stimdg:block_type] $i] 

        # Set the frames, by block type (note != not equal)
        #  round because frames must be integers
        if { $block_type == "fixation" } {
        set currOnFrames [expr round($fixBlockDur * $screenHz)]
        } else {  
        # Not fixation. Make it calculate for each of the 3 possible ON values
        set currOnFrames [expr round([dl_get $stimOnDur $i] * $screenHz)]
        
        }
        
        # offFrameN = onFrameN + currOnFrames (dur in frames)
        # Brings up an error if like this
        
        dl_put stimdg:offFrameN $i \
        [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
             + $currOnFrames]
        
        # Calculate the corresponding off time in seconds
        dl_put stimdg:offSec $i \
        [expr [lindex [dl_tcllist stimdg:offFrameN] $i] \
             / ($screenHz + 0.0)] ;#intro floating point
	
	set lasttrial [dl_last $ntrials]

	### Fixed so that last frame and endframe match
	    
	if {$i == [expr $lasttrial-1] } {
	    dl_put stimdg:endFrameN $i [dl_last stimdg:offFrameN]
	}
	
    } ;#end trial loop

};#end proc passive_seq
    
    proc seq_test  { monkey  block_order \
		       rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
	set maxtries 100
	for { set tries 0 } { $tries < $maxtries } { incr tries } {
	    if { [catch { try_seq_test $monkey $block_order \
			      $rwdInt_max $rwdInt_min \
			      $rwdInt_inc $rwdInt_n } ] == 0 } break
	}
	if { $tries == $maxtries } { error "unable to find sequence" }
    }
    

    
    proc try_seq_test  { monkey  block_order \
		       rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
    #Variables (set for each block)I think I have to set these after***
    #Habituation is going to run differently than the other types I think
    #Going to set conditions for habituation first
    
    set numBlocksEachCond 5
    set imgPerBlock 120
    set fixBlockDur 14
    set fixPresent 1 ;#fix spot present for everything
    set bgLuminance 255
    
    #Just to try this out I'm only going to use the scrambled objects for the habituation stim. Can't find whether any fractals live somewhere in folders
    #Only using scramobjects and fixation
    # 0 = Scrambled Objects, 1 = Fixation

    if [file exists c:/stimuli/MRILocalizers] {
        set mripath c:/stimuli/MRILocalizers
    } else {
        set mripath ../stimuli/MRILocalizers
    }

    dl_local imgFolders [eval dl_slist $mripath/scramobjects \
			     fixation]
    
    # Need to add fixation and figure the right way of getting out of dl
    set img_groups [dl_tcllist [dl_filebase $imgFolders]]
    set fixblocknum [lsearch $img_groups "fixation"]

          # Figure out the total number of stim/images that will need of each kind
    set nTotImg [expr $numBlocksEachCond * $imgPerBlock]
            
    # Ok, so let's try to make stimdg exist
    # stimdg
    # ------
    if {[dg_exists stimdg]} {
        dg_delete stimdg
    }

    dg_create stimdg

    dl_set stimdg:version [dl_slist [namespace current]]
 
    dl_set stimdg:block_n [dl_ilist]
    dl_set stimdg:block_id [dl_ilist]
    
    ###Now if block order is 0 then AAAA, if it's 1 then it'll be AAAB. Here 1 is AAAA and 6 is AAAB
    set fixation 0
    #####This piece of code shuffles and creates the block id list. FYI dl_shuffle can also shuffle llists.
    ###Instead of shuffling here, might be better instead to shuffle elsewhere... maybe after lists are created and then shuffle lists. 
    if {$block_order == 0} {
	dl_local habit [dl_ilist 1]
	dl_local deviants [dl_shuffle [dl_ilist 2 3 4 5]]
	set block_type [dl_interleave [dl_combine $habit $deviants] $fixation]
	
    } else {
	dl_local habit [dl_ilist 1]
       	dl_local deviants [dl_shuffle [dl_ilist 2 3 4 5]]
	set block_type [dl_interleave [dl_combine $habit $deviants] $fixation]
    }
    ###Makes the actual total list with the correct number of ids
    for {set i 0} {$i < [dl_llength $block_type]} {incr i} {
	set blocktypeid [dl_get $block_type $i]
	if {$blocktypeid != 0} {
	    dl_set stimdg:block_id [dl_combine stimdg:block_id [dl_repeat $blocktypeid $imgPerBlock]]
	} elseif {$blocktypeid == 0} {
	    dl_set stimdg:block_id [dl_append stimdg:block_id $blocktypeid]
	}
    }
    #####
    set nblocks [expr $numBlocksEachCond*2]
    dl_local block_n [dl_fromto 0 $nblocks]
    dl_local repeat_n \
        [dl_replicate [dl_ilist $imgPerBlock 1] $numBlocksEachCond]
    dl_set stimdg:block_n [dl_repeat $block_n $repeat_n]
    ###Place actual names of each stimtype next to its id
    dl_set stimdg:block_type [dl_repeat [dl_slist null] [dl_llength stimdg:block_id]]
    for {set i 0} {$i < [dl_llength stimdg:block_id]} {incr i} {
	set stimid [lindex [dl_tcllist stimdg:block_id] $i]
	if {$stimid == 1} {
	    if {$block_order == 0} {
		dl_put stimdg:block_type $i "AAAA"
	    } else {
		dl_put stimdg:block_type $i "AAAB"
	    }
	} elseif {$stimid == 2} {
	    dl_put stimdg:block_type $i "Dev1"
	} elseif {$stimid == 3} {
	    dl_put stimdg:block_type $i "Dev2"
	} elseif {$stimid == 4} {
	    dl_put stimdg:block_type $i "Dev3"
	} elseif {$stimid == 5} {
	    dl_put stimdg:block_type $i "Dev4"
	} elseif {$stimid == 0} {
	    dl_put stimdg:block_type $i "fixation"	    
	}; #End of if else
    }; #End of for loop

    
    #######Making the block order########################
    #Call up the images. For stim types, fixation code is 0
    
    set img1 ../stimuli/MRILocalizers/scramobjects/scramobjects_001.png
    set img2 ../stimuli/MRILocalizers/scramobjects/scramobjects_002.png
    set img3 ../stimuli/MRILocalizers/scramobjects/scramobjects_003.png
    set img4 ../stimuli/MRILocalizers/scramobjects/scramobjects_004.png
    set img5 ../stimuli/MRILocalizers/scramobjects/scramobjects_005.png
    set img6 ../stimuli/MRILocalizers/scramobjects/scramobjects_006.png
    set img7 ../stimuli/MRILocalizers/scramobjects/scramobjects_007.png
    
    set uq_block_id [dl_unique stimdg:block_id]
    
    for {set i 0} {$i < [dl_llength $uq_block_id]} {incr i} {
        
        set block_id_idx [dl_get $uq_block_id $i]
        
	if {$block_id_idx == 1} {
	    if {$block_order == 0} {
		set nstim 28
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_repeat "1 2 3 4" 7]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_select "1 2 3 4 21 22 23 24 25 26 27 28" [dl_randchoose 12 6]]]
		set stim_array [dl_repeat 9 $nstim]
	    }
        } elseif {$block_id_idx == 2} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 5 6 7 35 36 37]]
		set stim_array [dl_repeat 9 $nstim]
	    }
	} elseif {$block_id_idx == 3} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 29 30 31 32 33 34]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	} elseif {$block_id_idx == 4} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	    
	} else {
	    if {$block_order == 0} {
	    set nstim 30
            set stim_used [dl_zeros $nstim]
            set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	}
    #Find the next position to fill in
    
        set stim_idx [dl_findAll $stim_array "9"]

    #Go through each idx line individually  
        foreach stimline [dl_tcllist $stim_idx] {
        #First line can be any
        if {$stimline == 0} {
            #First stim
            #Find available stimuli
            set avail_stimidxs [dl_findAll $stim_used 0]

            #Choose randomly one of the available stimuli can use dl_pickone
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            
            dl_put $stim_array $stimline $actual_stim
            #This next put will mark the item in the zeros as used
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
        #First part logic is sound. Always gives you a new num and marks it where it should be.
        } else {
            #Find the available stimuli that are not the previous stimuli
            set laststim [dl_get $stim_array $lastLine]

	    if {$block_order == 0} {
            set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
						[dl_noteq $poss_stim $laststim]] "1"]
	    } else {
		#Ask to check for last again cause otherwise doesn't find it
		set laststim [dl_get $stim_array $lastLine]
		#Make sure that the ones that start with 1 aren't chosen
		if {[dl_get [dl_oneof $laststim "4 23 26"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
						        [dl_not [dl_oneof $poss_stim "1 2 3"]]] "1"]
		    #Make sure that the ones that start with 2 aren't chosen
		} elseif {[dl_get [dl_oneof $laststim "1 24 27"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "4 21 22"]]] "1"]
		    #Make sure that the ones that start with 3 aren't chosen
		} elseif {[dl_get [dl_oneof $laststim "2 21 28"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "23 24 25"]]] "1"]
		    #Make sure that the ones that start with 4 aren't chosen		    
		} elseif {[dl_get [dl_oneof $laststim "3 22 25"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "26 27 28"]]] "1"]
		    
		} else {
		    set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]] "1"]
		}
	    }
	
            if {[dl_llength $avail_stimidxs] == 0} {
        #Set list to 0 and pick first stim again
            set stim_used [dl_zeros $nstim]
            set avail_stimidxs [dl_findAll $stim_used 0]
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            dl_put $stim_array $stimline $actual_stim
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
                } else {
                if {[dl_llength $avail_stimidxs] > 1} {
                set chosen_idx [dl_pickone $avail_stimidxs]
                } else {
                set chosen_idx $avail_stimidxs
                }
            }
            
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
        }; #End of if else
        
        }; #End of Foreach
        
        if {$block_id_idx == 1} {
	    if {$block_order == 0} {
	    set first_block $stim_array
	    set laststimidx [dl_not [dl_oneof "1 2 3 4" [dl_last $first_block]]]
	    set first_extra [dl_pickone [dl_select "1 2 3 4" $laststimidx]]
	    set first_extraidx [dl_not [dl_oneof "1 2 3 4" $first_extra]]
	    set both_extra [dl_combine $first_extra [dl_pickone [dl_select \
								     "1 2 3 4" $first_extraidx]]]
	    set first_block [dl_combine $first_block $both_extra]
	    } else {
		set first_block $stim_array
	    }
	    
        } elseif {$block_id_idx == 2} {
	    set dev1_block $stim_array
	} elseif {$block_id_idx == 3} {
	    set dev2_block $stim_array
	} elseif {$block_id_idx == 4} {
	    set dev3_block $stim_array
	} elseif {$block_id_idx == 5} {
	    set dev4_block $stim_array
	}
    }; #End of for loop

    set blockamt 5
    
    for {set i 0} { $i < $blockamt} { incr i} {

        if {$i == 0} {
        set counter 1
        }
        
        
        if {$counter == 1} {
	    set stim_vals $first_block
	    set n_onstim 30
	    set ontime_used [dl_zeros $n_onstim]
	    set poss_ontime [dl_repeat "1 2 3 4 5 6" 5]
	    set time_array [dl_repeat 9 $n_onstim]
	    set time_arrayval [expr [dl_llength $time_array] - 1]
	    set uq_stim [dl_unique $first_block]
	    
        } elseif {$counter == 2} {
            #Number dev (N+S-)
            #Dev times for now will be 7 and 8
            set numdev 1
            set stim_vals $dev1_block
            set n_onstim 30
            set ontime_used [dl_zeros $n_onstim]
            set poss_ontime [dl_concat [dl_repeat "1 2 3 4 5 6" 4] [dl_repeat "7 8" 3]]
            set time_array [dl_repeat 9 $n_onstim]
            set time_arrayval [expr [dl_llength $time_array] - 1]
            set uq_stim [dl_unique $dev1_block]
         
        } elseif {$counter == 3} {
            #New exemplar of same rule(N-S-)
            set numdev 0
            set newexp 1
            set stim_vals $dev2_block
            set n_onstim 30
            set ontime_used [dl_zeros $n_onstim]
            set poss_ontime [dl_concat [dl_repeat "1 2 3 4 5 6" 4] [dl_repeat "10 11" 3]]
            set time_array [dl_repeat 9 $n_onstim]
            set time_arrayval [expr [dl_llength $time_array] - 1]
            set uq_stim [dl_unique $dev2_block]
	    
	} elseif {$counter == 4} {
            #Double dev (N+S+)
            set numdev 1
            set stim_vals $dev3_block
            set n_onstim 30
            set ontime_used [dl_zeros $n_onstim]
            set poss_ontime [dl_concat [dl_repeat "1 2 3 4 5 6" 4] [dl_repeat "7 8" 3]]
            set time_array [dl_repeat 9 $n_onstim]
            set time_arrayval [expr [dl_llength $time_array] - 1]
            set uq_stim [dl_unique $dev3_block]
         
        } elseif {$counter == 5} {
            #Sequence Dev (times are medium times for all items)(N-S+)
            set numdev 0
            set newexp 1
            set stim_vals $dev4_block
            set n_onstim 30
            set ontime_used [dl_zeros $n_onstim]
            set poss_ontime [dl_concat [dl_repeat "1 2 3 4 5 6" 4] [dl_repeat "10 11" 3]]
            set time_array [dl_repeat 9 $n_onstim]
            set time_arrayval [expr [dl_llength $time_array] - 1]
            set uq_stim [dl_unique $dev4_block]     
        }
        
        
        for {set ui 0} {$ui < [dl_llength $uq_stim]} {incr ui} {

             set stim [dl_get $uq_stim $ui]

             #Find the places in the stim_array that have that stim
             set stim_idxs [dl_findAll $stim_vals $stim]
        
             for {set si 0} {$si < [dl_llength $stim_idxs]} {incr si} {

             set stim_idx [dl_get $stim_idxs $si]
             # find all the available ones
             set avail_timeidxs [dl_eq $ontime_used 0]

             # decide avail times based on stim (hab or dev)
             if {[dl_get [dl_oneof $stim "1 2 3 4 21 22 23 24 25 26 27 28"] 0] == 1} {
                 set avail_times [dl_and [dl_eq $avail_timeidxs 1]\
                             [dl_eq [dl_oneof $poss_ontime "1 2 3 4 5 6"] 1]]

                 #Next statement is if stim is oneof 5-7 and num deviant (N+) is true, add this later
             } elseif {[dl_get [dl_and [dl_oneof $stim "5 6 7 8 10 11 18 19 20 35 36 37"] [dl_eq $numdev 1]] 0] == 1} {
                 # pick the long or short times (2 stim or 6 stim total)
                 set avail_times [dl_and [dl_eq $avail_timeidxs 1]\
                          [dl_eq [dl_oneof $poss_ontime "7 8"] 1]]
                 
             } elseif {[dl_get [dl_and [dl_oneof $stim "5 6 7 8 10 11 12 13 14 15 16 17 29 30 31 32 33 34"] [dl_eq $newexp 1]] 0] == 1} {
                 set avail_times [dl_and [dl_eq $avail_timeidxs 1]\
                          [dl_eq  [dl_oneof $poss_ontime "10 11"] 1]]
             # else if stim ismember 5-7 and N-
                 # always assign the medium times (4 stim total)
             }

             if {$stim_idx == 0} {
                 #First stim: find the available stimuli, avail times AND not the next one
                 set next_time [dl_get $time_array [expr $stim_idx + 1]]
            
                 # you need a line like this
                 set avail_timeidxs [dl_findAll [dl_and [dl_eq $avail_times 1]\
                            [dl_noteq $poss_ontime $next_time]\
                               ] "1"]
            
             } elseif {$stim_idx == [dl_last $time_arrayval]} {
                 #If it's the last stim
                 #Find available times: Are available AND not the prev time AND not time
                 #assigned to the previous stim of this kind
                 
                 set prev_time [dl_get $time_array [expr $stim_idx - 1]]
                 set prev_timeidxs [dl_get $time_array [dl_get $stim_idxs [expr $si - 1]]]
                       
                 if {$si == 0} {
                 set avail_timeidxs [dl_findAll\
                        [dl_and [dl_eq $avail_times 1]\
                             [dl_noteq $poss_ontime $prev_time]] "1"]
            
                 set chosen_idx [dl_pickone $avail_timeidxs]
                 } else {
            
                 set avail_timeidxs [dl_findAll\
                        [dl_and [dl_eq $avail_times 1]\
                             [dl_and [dl_noteq $poss_ontime $prev_time]\
                              [dl_noteq $poss_ontime $prev_timeidxs]\
                             ]] "1"]
                
                 }
                 if  {[dl_llength $avail_timeidxs] > 1} {
                 set chosen_idx [dl_pickone $avail_timeidxs]
                 } else {
                 set chosen_idx $avail_timeidxs
                 }
                 
             } else {
            
                 if {$si == 0} {
                 set prev_time [dl_get $time_array [expr $stim_idx - 1]]
                 set next_time [dl_get $time_array [expr $stim_idx + 1]]
            #No previous stim to check
                 set avail_timeidxs [dl_findAll [dl_and [dl_eq $avail_times 1]\
                                [dl_and [dl_noteq $poss_ontime $prev_time]\
                                 [dl_noteq $poss_ontime $next_time]]] "1"]
                 } else {
            
                 set prev_time [dl_get $time_array [expr $stim_idx - 1]]
                 set next_time [dl_get $time_array [expr $stim_idx + 1]]
                 set prev_timeidxs [dl_get $time_array [dl_get $stim_idxs [expr $si - 1]]]
            
                 set avail_timeidxs [dl_findAll [dl_and [dl_eq $avail_times 1]\
                                [dl_and [dl_noteq $poss_ontime $prev_time]\
                                 [dl_and [dl_noteq $poss_ontime $next_time]\
                                      [dl_noteq $poss_ontime $prev_timeidxs]]]] "1"]
         
	     }
                 if {[dl_llength $avail_timeidxs] > 1} {
                 set chosen_idx [dl_pickone $avail_timeidxs]
                 } elseif {[dl_llength $avail_timeidxs] == 1} {
                 set chosen_idx [dl_get $avail_timeidxs 0]
                 }
                 
             }
        
             set chosen_idx [dl_pickone $avail_timeidxs]
             set actual_time [dl_get $poss_ontime $chosen_idx]
             dl_put $time_array $stim_idx $actual_time
             dl_put $ontime_used $chosen_idx 1
             }; #End of si for loop
         }; #End of ui for loop
        
        if {$counter == 1} {
        set first_block_times $time_array
        
        } elseif {$counter == 2} {
        set dev1_block_times $time_array
        
        } elseif {$counter == 3} {
        set dev2_block_times $time_array
        
        } elseif {$counter == 4} {
        set dev3_block_times $time_array
        
        } elseif {$counter == 5} {
        set dev4_block_times $time_array
        
        }
	
        set counter [expr $counter+1]
    }; #End of other for loop
    
    ######Expanding each list to set them on stimdg##########
    ####Expand for stim type list
    #Expanded habit block AAAA
    if {$block_order == 0} {
	#This is for AAAA habit type seq
	set exphabit [dl_append [dl_repeat $first_block 4] 0]
	set exphabittimes [dl_append [dl_repeat $first_block_times 4] 0]
	#Expand dev 1/ second_block and use the same for the times, do the same for dev3
	###This gets it done for the image list 
	set dev1_time_rep [dl_repeat "9" [dl_llength $dev1_block_times]]

	for {set i 0} {$i < [dl_llength $dev1_block_times]} {incr i} {
	    set timeval [lindex [dl_tcllist $dev1_block_times] $i]
	    if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
		dl_put $dev1_time_rep $i 4
	    } elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
	    dl_put $dev1_time_rep $i 2
	    } elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
		dl_put $dev1_time_rep $i 6
	    }
	}
	set expdev1times [dl_append [dl_repeat $dev1_block_times $dev1_time_rep] 0]
            
	set expdev1 [dl_append [dl_repeat $dev1_block $dev1_time_rep] 0]
    
	set dev3_time_rep [dl_repeat "9" [dl_llength $dev3_block_times]]

	for {set i 0} {$i < [dl_llength $dev3_block_times]} {incr i} {
	    set timeval [lindex [dl_tcllist $dev3_block_times] $i]
	    if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
		dl_put $dev3_time_rep $i 4
	    } elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
		dl_put $dev3_time_rep $i 2
	    } elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
		dl_put $dev3_time_rep $i 6
	    }
	}
    
	set expdev3times [dl_append [dl_repeat $dev3_block_times $dev3_time_rep] 0]
            
	set expdev3 [dl_append [dl_repeat $dev3_block $dev3_time_rep] 0]

	#Expand dev 2
	set expdev2 [dl_append [dl_repeat $dev2_block 4] 0]
	set expdev2times [dl_append [dl_repeat $dev2_block_times 4] 0]
	#Aaaand now exp dev4 same way
	set expdev4 [dl_append [dl_repeat $dev4_block 4] 0]
	set expdev4times [dl_append [dl_repeat $dev4_block_times 4] 0]
    } else {
	#This is for AAAB habit type seq
	
	set exphabit [dl_append [dl_repeat $first_block 4] 0]
	set exphabittimes [dl_append [dl_repeat $first_block_times 4] 0]
	#Expand dev 1/ second_block and use the same for the times, do the same for dev3
	###This gets it done for the image list 
	set dev1_time_rep [dl_repeat "9" [dl_llength $dev1_block_times]]

	for {set i 0} {$i < [dl_llength $dev1_block_times]} {incr i} {
	    set timeval [lindex [dl_tcllist $dev1_block_times] $i]
	    if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
		dl_put $dev1_time_rep $i 4
	    } elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
	    dl_put $dev1_time_rep $i 2
	    } elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
		dl_put $dev1_time_rep $i 6
	    }
	}
	set expdev1times [dl_append [dl_repeat $dev1_block_times $dev1_time_rep] 0]
            
	set expdev1 [dl_append [dl_repeat $dev1_block $dev1_time_rep] 0]
    
	set dev3_time_rep [dl_repeat "9" [dl_llength $dev3_block_times]]

	for {set i 0} {$i < [dl_llength $dev3_block_times]} {incr i} {
	    set timeval [lindex [dl_tcllist $dev3_block_times] $i]
	    if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
		dl_put $dev3_time_rep $i 4
	    } elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
		dl_put $dev3_time_rep $i 2
	    } elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
		dl_put $dev3_time_rep $i 6
	    }
	}
    
	set expdev3times [dl_append [dl_repeat $dev3_block_times $dev3_time_rep] 0]
            
	set expdev3 [dl_append [dl_repeat $dev3_block $dev3_time_rep] 0]

	#Expand dev 2
	set expdev2 [dl_append [dl_repeat $dev2_block 4] 0]
	set expdev2times [dl_append [dl_repeat $dev2_block_times 4] 0]
	#Aaaand now exp dev4 same way
	set expdev4 [dl_append [dl_repeat $dev4_block 4] 0]
	set expdev4times [dl_append [dl_repeat $dev4_block_times 4] 0]	
    }
    
    ###Combine lists to get stim_types on stimdg
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id] 
    dl_set stimdg:stim_types [dl_ilist]
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $exphabit]
	} elseif { $idtestvals == 2 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev1]
	} elseif { $idtestvals == 3 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev2]
	} elseif { $idtestvals == 4 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev3]
	} elseif { $idtestvals == 5 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev4]
	}; #end of if else#
    }; #end of foreach

    
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id] 
    dl_set stimdg:on_type [dl_ilist]
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $exphabittimes]
	} elseif { $idtestvals == 2 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev1times]
	} elseif { $idtestvals == 3 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev2times]
	} elseif { $idtestvals == 4 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev3times]
	} elseif { $idtestvals == 5 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev4times]
	}; #end of if else#
    }; #end of foreach
    ###Append the expanded times to ontype stimdg so that they are registered for the totalon_type
                          
    set totalon_type stimdg:on_type
    #So far so good...
      dl_set stimdg:stimcountlist [dl_repeat "9" [dl_llength stimdg:stim_types]]
    set tasktrials [dl_llength stimdg:stim_types]
    
    dl_set stimdg:stimuli [dl_repeat [dl_slist null] $tasktrials]
    
    if {$block_order == 0} {
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
        
	    if {$stimIdx == 1} {
		dl_put stimdg:stimuli $i $img1
	    } elseif {$stimIdx == 2} {
		dl_put stimdg:stimuli $i $img2
	    } elseif {$stimIdx == 3} {
		dl_put stimdg:stimuli $i $img3
	    } elseif {$stimIdx == 4} {
		dl_put stimdg:stimuli $i $img4
	    } elseif {$stimIdx == 5} {
		dl_put stimdg:stimuli $i $img5          
	    } elseif {$stimIdx == 6} {
		dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 7} {
		dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 8} {
		#5-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 10} {
	    #6-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 11} {
		#7-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
		#5-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 19} {
		#6-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 20} {
		#7-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
		dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 13} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 14} {
		if {$imgcount == 4} {        
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}            
	    } elseif {$stimIdx == 15} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 16} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}        
	    } elseif {$stimIdx == 17} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}        
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
        
	}; #End of for loop assigning imgs
    } else {
	
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
	    #Will have individual id for each habit combination
	    
	    if {$stimIdx == 1} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 2} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 3} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 4} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 11} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 21} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img2
		}          
	    } elseif {$stimIdx == 22} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 23} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 24} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 25} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 26} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img4
		}          
	    } elseif {$stimIdx == 27} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 28} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 29} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 30} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 31} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 32} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 33} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}
	    } elseif {$stimIdx == 34} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}		
	    } elseif {$stimIdx == 5} {
		#5-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 6} {
		#5-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 7} {
		#6-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 8} {
	        dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 10} {
		dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 36} {
		#7-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
	        dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 19} {
	        dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 20} {
	        dl_put stimdg:stimuli $i $img7		
	    } elseif {$stimIdx == 35} {
		#6-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 37} {
		#7-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
		dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
	        dl_put stimdg:stimuli $i $img5
		
	    } elseif {$stimIdx == 13} {
		dl_put stimdg:stimuli $i $img5
        
	    } elseif {$stimIdx == 14} {
		dl_put stimdg:stimuli $i $img6
	               
	    } elseif {$stimIdx == 15} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 16} {
		dl_put stimdg:stimuli $i $img7
		       
	    } elseif {$stimIdx == 17} {
		dl_put stimdg:stimuli $i $img7
		      
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
	}; #End of for loop assigning imgs
    }; #End of if else statement
    
    # Figure out how long each frame is based on refresh rate
    # FrameDuration ;# gives answer in *ms*
    set screenHz [screen_set RefreshRate] ;# frames/sec
    # For debugging in tcl
    #set screenHz 60
    
           # Reward
    # ------
    # Grab rewardDuration from the (quick)params
    # set reward_amount 250
    # dl_set stimdg:rewardDuration [dl_repeat $reward_amount $ntrials]

    set ntrials [dl_llength stimdg:block_id]
    dl_set stimdg:rwdInt_max [dl_repeat $rwdInt_max $ntrials]
    dl_set stimdg:rwdInt_min [dl_repeat $rwdInt_min $ntrials]
    dl_set stimdg:rwdInt_inc [dl_repeat $rwdInt_inc $ntrials]
    dl_set stimdg:rwdInt_n [dl_repeat $rwdInt_n $ntrials]

    # Want the fixation spot present for all the trials
    dl_set stimdg:fixPresent [dl_repeat $fixPresent $ntrials]
    dl_set stimdg:background_luminance [dl_repeat $bgLuminance $ntrials]

    ###This is to assign the possible ontimes. This is where we're making the real stimOnDur\
    ###for this task
    ###Set empty stimdg first
    set on_Sec [dl_repeat 0.1 [dl_llength $totalon_type]]
    
        ###Now need to set the stimOffDur
    set off_Sec [dl_repeat 0.1 [dl_llength $totalon_type]]
    dl_set stimdg:offSecIdx [dl_findAll $off_Sec 0.1]
    dl_set stimdg:countlist [dl_repeat "9" [dl_llength $totalon_type]]
    ####Set the last off times to vars that substract from 2.5 (TR is now eq to 2.5)
    
    for {set i 0} { $i < [dl_llength $totalon_type] } { incr i} {

        if {$i == 0} {
        set count 1
        } 
        
        dl_put stimdg:countlist $i $count 
        set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
        set onstimIdx [lindex [dl_tcllist $totalon_type] $i]
        
        if {$onstimIdx == 1} {
        dl_put $on_Sec $i 0.1
        
        if {$count == 4} {
            dl_put $off_Sec $i 1.4
        } else {
            dl_put $off_Sec $i 0.2333
        }
        } elseif {$onstimIdx == 2} {
        dl_put $on_Sec $i 0.2

        if {$count == 4} {
            dl_put $off_Sec $i 1.4
        } else {
            dl_put $off_Sec $i 0.1
        }
        } elseif {$onstimIdx == 3} {
        dl_put $on_Sec $i 0.3
        if {$count == 4} {
            dl_put $off_Sec $i 0.8
        } else {
            dl_put $off_Sec $i 0.1667
        }
        } elseif {$onstimIdx == 4} {
        dl_put $on_Sec $i 0.1
        if {$count == 4} {
            dl_put $off_Sec $i 0.8
        } else {
            dl_put $off_Sec $i 0.4333
        }
        } elseif {$onstimIdx == 5} {
        dl_put $on_Sec $i 0.2
        if {$count == 4} {
            dl_put $off_Sec $i 0.2
        } else {
            dl_put $off_Sec $i 0.5
        }
        } elseif {$onstimIdx == 6} {
        dl_put $on_Sec $i 0.3
        if {$count == 4} {
            dl_put $off_Sec $i 0.2
        } else {
        dl_put $off_Sec $i 0.3667
        }
        } elseif {$onstimIdx == 7} {
        dl_put $on_Sec $i 0.2
        if {$count == 2} {
            dl_put $off_Sec $i 1.4
        } else {
            dl_put $off_Sec $i 0.7
        }
        } elseif {$onstimIdx == 8} {
        dl_put $on_Sec $i 0.2
        if {$count == 6} {
            dl_put $off_Sec $i 0.2
        } else {
            dl_put $off_Sec $i 0.22
        }
        } elseif {$onstimIdx == 10} {
        dl_put $on_Sec $i 0.2
        if {$count == 4} {
            dl_put $off_Sec $i 0.8
        } else {
            dl_put $off_Sec $i 0.3
        }
        } elseif {$onstimIdx == 11} {
        dl_put $on_Sec $i 0.2
        if {$count == 4} {
            dl_put $off_Sec $i 0.8
        } else {
            dl_put $off_Sec $i 0.3
        }
        } elseif {$onstimIdx == 0} {
        dl_put $on_Sec $i 14.0
        }; #end if/else statement
        

        set count [expr $count+1]

        if {$i < [expr [dl_llength $totalon_type]-1]} {
        
            if {[dl_get $totalon_type $i] != [dl_get $totalon_type [expr $i+1]]} {
            set count 1
            }
        }
        

    }; #end for loop
    
    set restofonsec [dl_repeat 0.1 [expr $ntrials - [dl_llength $on_Sec]]]
    
    set stimOnDur [dl_combine $on_Sec $restofonsec]
    dl_set stimdg:on_type $totalon_type

    set restofoffsec [dl_repeat 0.1 [expr $ntrials - [dl_llength $on_Sec]]]
    set stimOffDur [dl_prepend [dl_combine $off_Sec $restofoffsec] 0]
    
    
    
    #### 
    dl_set stimdg:onSec [dl_repeat 0.1 $ntrials]
    dl_set stimdg:offSec [dl_repeat 0.1 $ntrials]
    # Initialize the columns for frame numbers (always integers)
    dl_set stimdg:onFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:offFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:endFrameN [dl_repeat 0 $ntrials]

    for { set i 0 } { $i < $ntrials } { incr i } {
        # Have a choice, can either calculate the times and attempt
        #  to get the frames right, or can calculate the frames, and 
        #  calculate the times accordingly.
        # This is frame-based

        #onSec
        #-----
        if {$i == 0} {
        # First trial
        #dl_put stimdg:onSec $i 0
        dl_put stimdg:onFrameN $i 0
        } else {
        # previous block type
        set prev_block_type [lindex [dl_tcllist stimdg:block_type] \
                     [expr $i - 1]]
        
        # Set the frames, by prev block type
        if { $prev_block_type == "fixation" } {
            set prevOffFrames 0
        } else {
            # round because frames must be integers
            set prevOffFrames [expr round([dl_get $stimOffDur $i] * $screenHz)]
        }

        #onFrameN = previous trial offFrame + 
        #           prevOffFrames (duration in frames)
        dl_put stimdg:onFrameN $i \
            [expr [lindex [dl_tcllist stimdg:offFrameN] [expr $i - 1]] \
             + $prevOffFrames]

        # Also set the previous end frame. 
        #  Repeats info, but keeps the iti explicit
        dl_put stimdg:endFrameN [expr $i - 1] \
            [dl_get stimdg:onFrameN $i]
        }
        # Calculate the corresponding on time in seconds
        dl_put stimdg:onSec $i \
        [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
             / ($screenHz + 0.0)] ;#intro floating point

        #offSec
        #------
        # Get the current block type, fixation or otherwise
        set block_type [lindex [dl_tcllist stimdg:block_type] $i] 

        # Set the frames, by block type (note != not equal)
        #  round because frames must be integers
        if { $block_type == "fixation" } {
        set currOnFrames [expr round($fixBlockDur * $screenHz)]
        } else {  
        # Not fixation. Make it calculate for each of the 3 possible ON values
        set currOnFrames [expr round([dl_get $stimOnDur $i] * $screenHz)]
        
        }
        
        # offFrameN = onFrameN + currOnFrames (dur in frames)
        # Brings up an error if like this
        
        dl_put stimdg:offFrameN $i \
        [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
             + $currOnFrames]
        
        # Calculate the corresponding off time in seconds
        dl_put stimdg:offSec $i \
        [expr [lindex [dl_tcllist stimdg:offFrameN] $i] \
             / ($screenHz + 0.0)] ;#intro floating point
        
    } ;#end trial loop
  
};#end proc seq_test

  
proc jitter_pseq  { monkey session block_order \
		       rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
	set maxtries 200
	for { set tries 0 } { $tries < $maxtries } { incr tries } {
	    if { [catch { try_jitter_pseq $monkey $session $block_order \
			      $rwdInt_max $rwdInt_min \
			      $rwdInt_inc $rwdInt_n } ] == 0 } break
	}
	if { $tries == $maxtries } { error "unable to find sequence" }
}


#Tries jitter pseq a certain amount of tries if gets stuck

proc try_jitter_pseq { monkey session block_order \
		        rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
        
    set numBlocksEachCond 5
    set imgPerBlock 120
    set fixBlockDur 14
    set fixPresent 1 ;#fix spot present for everything
    set bgLuminance 255
    
    #Just to try this out I'm only going to use the scrambled objects for the habituation stim. Can't find whether any fractals live somewhere in folders
    #Only using scramobjects and fixation
    # 0 = Scrambled Objects, 1 = Fixation

    if [file exists c:/stimuli/MRILocalizers] {
        set mripath c:/stimuli/MRILocalizers
    } else {
        set mripath ../stimuli/MRILocalizers
    }

    dl_local imgFolders [eval dl_slist $mripath/scramobjects \
			     fixation]
    
    # Need to add fixation and figure the right way of getting out of dl
    set img_groups [dl_tcllist [dl_filebase $imgFolders]]
    set fixblocknum [lsearch $img_groups "fixation"]

          # Figure out the total number of stim/images that will need of each kind
    set nTotImg [expr $numBlocksEachCond * $imgPerBlock]
            
    # Ok, so let's try to make stimdg exist
    # stimdg
    # ------
    if {[dg_exists stimdg]} {
        dg_delete stimdg
    }

    dg_create stimdg

    ###Now if block order is 0 then AAAA, if it's 1 then it'll be AAAB. Here 1 is AAAA and 6 is AAAB
    set fixation 0
 
    ################## NYR 8/8/2018 ####################
    # Using ITIs and variable values generated by DBasu
    # Might not need many of the vars set before
    # Load table to use from possible 20 ITI tables, for now loading just 1 to test
    # Diana wrote me a load var func, using below 
    #loading in a table in task code
    #with flexible selection for tables stored in a directory

    set basefile mri/Scan_seq/pseq_itis/pseq ;#file folder
    set ext .dgz ;#name of extension of table
    #Add in remaining lists and list nums for random selection
    set filenum [dl_pickone [dl_ilist 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20] ] ;#identifier in name of file
    set filename $basefile${filenum}${ext}; #combine pieces
    set pseq_file [dg_read $filename] ;#loads in table

    
    #set pseq_file [dg_read L:/projects/stimulator2/mri/N_localizers/pseq_itis/pseq1.dgz]

    #Get basics from the table, blockid, set block names and give block numbers.
    #Grabbed directly from table to no need to shuffle blocks or do anything here
    #Change to int bc gets saved as a float when loaded to .dgz
    
    set table_blockid [dl_int $pseq_file:blockid]
    set timeid [dl_int $pseq_file:timeid] 
    
    #Want to keep original block id list but also want to have shuffled list
    if {$block_order == 0} {
	dl_local habit [dl_ilist 1]
	dl_local deviants [dl_shuffle [dl_ilist 2 3 4 5]]
	set block_type [dl_interleave [dl_combine $habit $deviants] $fixation]
	
    } else {
	dl_local habit [dl_ilist 1]
       	dl_local deviants [dl_shuffle [dl_ilist 2 3 4 5]]
	set block_type [dl_interleave [dl_combine $habit $deviants] $fixation]
    }

    #Call up the images. For stim types, fixation code is 0
    #Changing how images will be called. Will use something similar to what Diana wrote me for selecting dgzs
    #Added session as an option so can select designated sess images
    set filefolder ../stimuli/MRILocalizers/fractals/
    set ext .png ;#name of extension of image
    #set filename $basefile${filenum}${ext}; #example to combine pieces
    set filename "_fractal_"
    
    for {set i 1} {$i < 8} {incr i} {
	set img$i $filefolder${session}${filename}${i}${ext}
    }
    
    #Separate list by blocks
    #Get uq_block ids from pseq list without sorting
     
    #cycle through to separate 
    
    #Get time ids and change to integers
    set time_vals [dl_int $pseq_file:timeid]
    #Have to use time list to assign images
    #Grab unique time values

    #set uq_time_vals [dl_uniqueNoSort $time_vals]
    #set uq_time_length [dl_length $uq_time_vals]

    set table_blockid_length [dl_length $table_blockid]
    
    #Now that have time vals separate into blocks
    #Will probably want to do the same later for times and to assign times to blocks
    
    set habit_block_vals [dl_repeat 9 $table_blockid_length]
    set numdev_block_vals [dl_repeat 9 $table_blockid_length]
    set newexp_block_vals [dl_repeat 9 $table_blockid_length]
    set numpat_block_vals [dl_repeat 9 $table_blockid_length]
    set patdev_block_vals [dl_repeat 9 $table_blockid_length]
    
    for {set i 0} { $i < $table_blockid_length } {incr i} {

	set table_blockid_val [dl_get $table_blockid $i]
	if {$table_blockid_val == 1} {
	    set habit_val [dl_get $time_vals $i]
	    dl_put $habit_block_vals $i $habit_val
	} elseif {$table_blockid_val == 2} {
	    set numdev_val [dl_get $time_vals $i]
	    dl_put $numdev_block_vals $i $numdev_val
	} elseif {$table_blockid_val == 3} {
	    set newexp_val [dl_get $time_vals $i]
	    dl_put $newexp_block_vals $i $newexp_val
	} elseif {$table_blockid_val == 4} {
	    set numpat_val [dl_get $time_vals $i]
	    dl_put $numpat_block_vals $i $numpat_val
	} elseif {$table_blockid_val == 5} {
	    set patdev_val [dl_get $time_vals $i]
	    dl_put $patdev_block_vals $i $patdev_val
	    
	}; #end of if else statement
    }; #end of for loop

    # Need to remove 9's from lists to have values isolated in blocks

    set habit_block_vals [dl_select $habit_block_vals [dl_findAll [dl_noteq $habit_block_vals 9] 1]]
    set numdev_block_vals [dl_select $numdev_block_vals [dl_findAll [dl_noteq $numdev_block_vals 9] 1]]
    set newexp_block_vals [dl_select $newexp_block_vals [dl_findAll [dl_noteq $newexp_block_vals 9] 1]]
    set numpat_block_vals [dl_select $numpat_block_vals [dl_findAll [dl_noteq $numpat_block_vals 9] 1]]
    set patdev_block_vals [dl_select $patdev_block_vals [dl_findAll [dl_noteq $patdev_block_vals 9] 1]]

    #Keep names already used in code to avoid problems. The block lists right now are too long.
    #Make into lists that only contain unique values.

    set first_block [dl_uniqueNoSort $habit_block_vals]
    set dev1_block [dl_uniqueNoSort $numdev_block_vals]
    set dev2_block [dl_uniqueNoSort $newexp_block_vals]
    set dev3_block [dl_uniqueNoSort $numpat_block_vals]
    set dev4_block [dl_uniqueNoSort $patdev_block_vals]

    #Go into loop for picking stims. Use number values for time to select image stimuli ids
    if {$block_order == 0} {
	set blockamt 5
	
	for {set i 0} { $i < $blockamt} { incr i} {

	    if {$i == 0} {
		set counter 1
	    }
	    
	    if {$counter == 1} {
		#Habituation
		set time_vals $first_block
		set n_stim_vals 30
		set stim_vals_used [dl_zeros $n_stim_vals]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 7] [dl_select "1 2 3 4" [dl_randchoose 4 2]]]
		set stim_array [dl_repeat 9 $n_stim_vals]
		set stim_arrayval [expr [dl_llength $stim_array] - 1]
		set uq_times [dl_unique $first_block]
		
	    } elseif {$counter == 2} {
		#Number dev
		#Dev times for now will be 7 and 8
		set numdev 1
		set time_vals $dev1_block
		set n_stim_vals 30
		set stim_vals_used [dl_zeros $n_stim_vals]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $n_stim_vals]
		set stim_arrayval [expr [dl_llength $stim_array] - 1]
		set uq_times [dl_unique $dev1_block]
		
	    } elseif {$counter == 3} {
		#New exemplar of same rule
		set numdev 0
		set newexp 1
		set time_vals $dev2_block
		set n_stim_vals 30
		set stim_vals_used [dl_zeros $n_stim_vals]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $n_stim_vals]
		set stim_arrayval [expr [dl_llength $stim_array] - 1]
		set uq_times [dl_unique $dev2_block]
		
	    } elseif {$counter == 4} {
		#Double dev
		set newexp 0
		set doubledev 1
		set time_vals $dev3_block
		set n_stim_vals 30
		set stim_vals_used [dl_zeros $n_stim_vals]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $n_stim_vals]
		set stim_arrayval [expr [dl_llength $stim_array] - 1]
		set uq_times [dl_unique $dev3_block]
		
	    } elseif {$counter == 5} {
		#Sequence Dev (times are medium times for all items)
		set doubledev 0
		set patdev 1
		set time_vals $dev4_block
		set n_stim_vals 30
		set stim_vals_used [dl_zeros $n_stim_vals]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $n_stim_vals]
		set stim_arrayval [expr [dl_llength $stim_array] - 1]
		set uq_times [dl_unique $dev4_block]
		
	    }
	    
	    for {set ui 0} {$ui < [dl_llength $uq_times]} {incr ui} {

		set times [dl_get $uq_times $ui]

		#Find the places in the time_vals that have that time
		set time_idxs [dl_findAll $time_vals $times]
		
		for {set si 0} {$si < [dl_llength $time_idxs]} {incr si} {

		    set time_idx [dl_get $time_idxs $si]
		    # find all the available ones
		    set avail_stimidxs [dl_eq $stim_vals_used 0]

		    # decide avail stim based on times (hab or dev time ids)
		    if {[dl_get [dl_oneof $times "1 2 3 4 5 6"] 0] == 1} {
			set avail_stim [dl_and [dl_eq $avail_stimidxs 1]\
					    [dl_eq [dl_oneof $poss_stim "1 2 3 4 21 22 23 24 25 26 27 28"] 1]]

			#Next statement is if stim is oneof 5-7 and num deviant (N+) is true, add this later
		    } elseif {[dl_get [dl_and [dl_oneof $times "7 8"] [dl_eq $numdev 1]] 0] == 1} {
			# pick the long or short timesstim that correspond to number devs (2 stim or 6 stim total)
			set avail_stim [dl_and [dl_eq $avail_stimidxs 1]\
					    [dl_eq [dl_oneof $poss_stim "5 6 7 35 36 37"] 1]]
			
		    } elseif {[dl_get [dl_and [dl_oneof $times "10"] [dl_eq $newexp 1]] 0] == 1} {
			set avail_stim [dl_and [dl_eq $avail_stimidxs 1]\
					    [dl_eq  [dl_oneof $poss_stim "5 6 7 29 30 31 32 33 34"] 1]]
			
			# else if stim ismember 5-7 and N-
			# always assign the medium times (4 stim total)
		    } elseif {[dl_get [dl_and [dl_oneof $times "7 8"] [dl_eq $doubledev 1]] 0] == 1} {
			# pick the long or short timesstim that correspond to number devs (2 stim or 6 stim total)
			set avail_stim [dl_and [dl_eq $avail_stimidxs 1]\
					    [dl_eq [dl_oneof $poss_stim "8 10 11 18 19 20"] 1]]
			
		    } elseif {[dl_get [dl_and [dl_oneof $times "10"] [dl_eq $patdev 1]] 0] == 1} {
			
			set avail_stim [dl_and [dl_eq $avail_stimidxs 1]\
					    [dl_eq  [dl_oneof $poss_stim "12 13 14 15 16 17"] 1]]
			
		    }

		    if {$time_idx == 0} {
			#First stim: find the available stimuli, avail times AND not the next one
			set next_stim [dl_get $stim_array [expr $time_idx + 1]]
			
			# you need a line like this
			set avail_stimidxs [dl_findAll [dl_and [dl_eq $avail_stim 1]\
							    [dl_noteq $poss_stim $next_stim]\
							   ] "1"]
			
		    } elseif {$time_idx == [dl_last $stim_arrayval]} {
			#If it's the last stim
			#Find available times: Are available AND not the prev time AND not time
			#assigned to the previous stim of this kind
			
			set prev_stim [dl_get $stim_array [expr $time_idx - 1]]
			set prev_stimidxs [dl_get $stim_array [dl_get $time_idxs [expr $si - 1]]]
			
			if {$si == 0} {
			    set avail_stimidxs [dl_findAll\
						    [dl_and [dl_eq $avail_stim 1]\
							 [dl_noteq $poss_stim $prev_stim]] "1"]
			    
			    set chosen_idx [dl_pickone $avail_stimidxs]
			} else {
			    
			    set avail_stimidxs [dl_findAll\
						    [dl_and [dl_eq $avail_stim 1]\
							 [dl_and [dl_noteq $poss_stim $prev_stim]\
							      [dl_noteq $poss_stim $prev_stimidxs]\
							     ]] "1"]
			    
			}
			if  {[dl_llength $avail_stimidxs] > 1} {
			    set chosen_idx [dl_pickone $avail_stimidxs]
			} else {
			    set chosen_idx $avail_stimidxs
			}
			
		    } else {
			#NYR 10/23/2018 Fixing bug for picking stims.
			if {$si == 0} {
			    set prev_stim [dl_get $stim_array [expr $time_idx - 1]]
			    set next_stim [dl_get $stim_array [expr $time_idx + 1]]
			    set avail_stimidxs [dl_findAll [dl_and [dl_eq $avail_stim 1]\
								[dl_and [dl_noteq $poss_stim $prev_stim]\
								     [dl_noteq $poss_stim $next_stim]]] "1"]
			} else {

			    set prev_stim [dl_get $stim_array [expr $time_idx - 1]]
			    set next_stim [dl_get $stim_array [expr $time_idx + 1]]
			    set prev_stimidxs [dl_get $stim_array [dl_get $time_idxs [expr $si - 1]]]  	     
			    set avail_stimidxs [dl_findAll [dl_and [dl_eq $avail_stim 1]\
								[dl_and [dl_noteq $poss_stim $prev_stim]\
								     [dl_and [dl_noteq $poss_stim $next_stim]\
									  [dl_noteq $poss_stim $prev_stimidxs]]]] "1"]
			}
			if {[dl_llength $avail_stimidxs] > 1} {
			    set chosen_idx [dl_pickone $avail_stimidxs]
			} elseif {[dl_llength $avail_stimidxs] == 1} {
			    set chosen_idx [dl_get $avail_stimidxs 0]
			}
			
		    }
		    
		    set chosen_idx [dl_pickone $avail_stimidxs]
		    set actual_stim [dl_get $poss_stim $chosen_idx]
		    dl_put $stim_array $time_idx $actual_stim
		    dl_put $stim_vals_used $chosen_idx 1
		}; #End of si for loop
	    }; #End of ui for loop
	    if {$counter == 1} {
		set first_block_stim $stim_array
	    } elseif {$counter == 2} {
		set dev1_block_stim $stim_array
	    } elseif {$counter == 3} {
		set dev2_block_stim $stim_array
	    } elseif {$counter == 4} {
		set dev3_block_stim $stim_array
	    } elseif {$counter == 5} {
		set dev4_block_stim $stim_array
	    }
	    set counter [expr $counter+1]
	}; #End of other for loop
    } else {
	#inputs for proc should be uqtimes_lists
	set nerase 5
	set nstim 30
	set nblocks 5

	for {set ti 0} {$ti < $nblocks} {incr ti} {
	    if {$ti == 0} {
		set comb_last [dl_ilist 2 3 4 1 3 4 1 2 4 1 2 3]; #Should find a way to not be hardcoded
		set comb_first [dl_repeat "1 2 3 4" 3]
		set combos [dl_llist $comb_first $comb_last]
		set time_list $first_block
	    } elseif {$ti == 1} {
		set comb_last [dl_ilist 2 3 4 1 3 4 1 2 4 1 2 3 6 7 5 7 5 6];
		set comb_first [dl_concat [dl_repeat "1 2 3 4" 3] [dl_repeat "5 6 7" 2]]
		set combos [dl_llist $comb_first $comb_last]
		set time_list $dev1_block
	    } elseif {$ti == 2} {
		set comb_last [dl_ilist 2 3 4 1 3 4 1 2 4 1 2 3 6 7 5 7 5 6];
		set comb_first [dl_concat [dl_repeat "1 2 3 4" 3] [dl_repeat "5 6 7" 2]]
		set combos [dl_llist $comb_first $comb_last]
		set time_list $dev2_block
	    } elseif {$ti == 3} {
		set comb_last [dl_ilist 2 3 4 1 3 4 1 2 4 1 2 3 6 7 5 7 5 6];
		set comb_first [dl_concat [dl_repeat "1 2 3 4" 3] [dl_repeat "5 6 7" 2]]
		set combos [dl_llist $comb_first $comb_last]
		set time_list $dev3_block
	    } else {
		set comb_last [dl_ilist 2 3 4 1 3 4 1 2 4 1 2 3 6 7 5 7 5 6];
		set comb_first [dl_concat [dl_repeat "1 2 3 4" 3] [dl_repeat "5 6 7" 2]]
		set combos [dl_llist $comb_first $comb_last]
		set time_list $dev4_block
	    }
	    
	    set ncombos [dl_get [dl_first [dl_llength $combos]] 0]
	    #Determine ilegal combos 
	    #Go through combo list one by one.
	    set illegal_combo_num [dl_ilist]
	    set illegal_combo_ids [dl_ilist]
	    for {set ci 0} {$ci < $ncombos} {incr ci} {
		#Find the indices of all the combos that start with what the current combo ends with
		set comb [dl_get $comb_last $ci]
		set idxs [dl_findAll $comb_first $comb]
		#Match the number of the idxs to the number that identifies what illegal combo it is
		set illegal_combo_num [dl_concat $illegal_combo_num [dl_repeatElements $ci [dl_first [dl_length $idxs] ] ] ]
		set illegal_combo_ids [dl_concat $illegal_combo_ids $idxs]
	    }
	    
	    #Already have time list. Move on to pick stim.
	    set neach [dl_floor [expr $nstim/$ncombos]]
	    set raw_combo_list [dl_repeat [dl_fromto [dl_min $illegal_combo_num] $ncombos] $neach]
	    #If there are any that are not filled in pick randomly
	    if {[dl_length $raw_combo_list] < $nstim} {
		if {$ti == 0} {
		    set raw_combo_list [dl_concat $raw_combo_list\
					    [dl_randchoose $ncombos [expr $nstim-[dl_length $raw_combo_list]]]]	   
		} else {
		    set raw_combo_list [dl_concat $raw_combo_list\
					    [dl_randchoose [expr $ncombos-6] [expr $nstim-[dl_length $raw_combo_list]]]]	   
		}
	    }

	    #Initialize for picking stims.
	    set stim_used [dl_zeros $nstim]
	    set combo_list [dl_repeat [dl_ilist 20] $nstim]

	    #set si 0
	    #When done debugging change condition back to [expr $nstim-1]
	    #while {$si <= [expr $nstim-1]} {}
	    for {set si 0} {$si < $nstim} {incr si} {
		if {$si == 0} {
		    #First stim
		    #Find available stimuli, which should be all right now
		    set avail_stimidxs [dl_findAll $stim_used 0]
		    set chosen_idx [dl_get [dl_pickone $avail_stimidxs] 0]
		    #Put the chosen combo value at that index
		    dl_put $combo_list $si [dl_get $raw_combo_list $chosen_idx]
		} else {
		    #Find avail stim that are not the previous stim, not one of illegal
		    #stim combos and not previosuly used for this timing
		    set illegal_choices [dl_select $illegal_combo_ids\
					     [dl_findAll $illegal_combo_num [dl_get $combo_list [expr $si-1]]]]
		    #Check all times this particular timing exists and check what was used to not repeat
		    set prev_time_choices [dl_select $combo_list [dl_eq $time_list [dl_get $time_list $si]]]
		    set curr_time_choice [dl_get $time_list $si]
		    #Need to have it be selective for deviant choices
		    if {[dl_get [dl_oneof $curr_time_choice "7 8 10"] 0] == 1} {
			set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_and [dl_and [dl_eq $stim_used 0]\
										    [dl_noteq $raw_combo_list\
											 [dl_get $combo_list\
											      [expr $si-1]]]]\
									    [dl_not [dl_oneof $raw_combo_list\
											 $illegal_choices]]]\
								    [dl_oneof $raw_combo_list "12 13 14 15 16 17"]]\
							    [dl_not [dl_oneof\
									 $raw_combo_list $prev_time_choices]]] 1]
		    } else {
			#Now make selection for avail ids where stim_used is 0 and is not
			#equal to the prev id, is not a member of the combo list if it's an
			#illegal choice (here given as a list of 0 and 1. 0 is for the ones
			#that are members and 1 are not), and is not member in combo list of prev times
			set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_and [dl_and [dl_eq $stim_used 0]\
										    [dl_noteq $raw_combo_list\
											 [dl_get $combo_list\
											      [expr $si-1]]]]\
									    [dl_not [dl_oneof $raw_combo_list\
											 $illegal_choices]]]\
								    [dl_oneof $raw_combo_list [dl_fromto 0 12]]]\
							    [dl_not [dl_oneof\
									 $raw_combo_list $prev_time_choices]]] 1]

		    }
		    if {[dl_length $avail_stimidxs] == 0} {
			#Need to eliminate this error message to try out erase proc
			#call erase function. Try this out after completing rest
			#clear the previous chosen_idx
			
			set chosen_idx [dl_ilist]
			#Error func and other stuff would go here
			set subg [erase_combs $nerase $combo_list $stim_used $raw_combo_list]
			# Take each of the columns and assign them to what they should be
			foreach column [dg_tclListnames $subg] {
			    dl_set stimdg:$column $subg:$column
			}
			dg_delete $subg
			
			set combo_list stimdg:combo_list
			set stim_used stimdg:stim_used
			
			set si [expr $si-[expr $nerase+1]]
			
		    } else {
			if {[dl_length $avail_stimidxs] > 1} {
			    set chosen_idx [dl_get [dl_pickone $avail_stimidxs] 0]
			} elseif {[dl_get [dl_length $avail_stimidxs] 0] == 1}  {
			    set chosen_idx [dl_get $avail_stimidxs 0]
			}
			dl_put $combo_list $si [dl_get $raw_combo_list $chosen_idx]
		    }
		}
		
		if {[dl_length $chosen_idx] != 0} {
		    dl_put $stim_used $chosen_idx 1

		    #set si [expr $si+1]
		}
	    }; #End of while
	    if {$ti == 0} {
		set habit_stims $combo_list
	    } elseif {$ti == 1} {
		set dev1_stims $combo_list
	    } elseif {$ti == 2} {
		set dev2_stims $combo_list
	    } elseif {$ti == 3} {
		set dev3_stims $combo_list
	    } elseif {$ti == 4} {
		set dev4_stims $combo_list
	    }
	}; #end of for loop


	#Change codes of everything. Initialize lists to fill up.
	for {set b 0} {$b <$nblocks} {incr b} {
	    if {$b == 0} {
		set change_stim [dl_repeat "40" [dl_length $habit_stims]]
		set stim_list $habit_stims
	    } elseif {$b == 1} {
		set change_stim [dl_repeat "40" [dl_length $habit_stims]]
		set stim_list $dev1_stims
	    } elseif {$b == 2} {
		set change_stim [dl_repeat "40" [dl_length $habit_stims]]
		set stim_list $dev2_stims
	    } elseif {$b == 3} {
		set change_stim [dl_repeat "40" [dl_length $habit_stims]]
		set stim_list $dev3_stims
	    } elseif {$b == 4} {
		set change_stim [dl_repeat "40" [dl_length $habit_stims]]
		set stim_list $dev4_stims
	    }

	    for {set i 0} {$i < [dl_length $habit_stims]} {incr i} {
		set stimIdx [lindex [dl_tcllist $stim_list] $i]
		if {$stimIdx == 0} {
		    dl_put $change_stim $i 1
		} elseif {$stimIdx == 1} {
		    dl_put $change_stim $i 2
		}  elseif {$stimIdx == 2} {
		    dl_put $change_stim $i 3
		} elseif {$stimIdx == 3} {
		    dl_put $change_stim $i 4
		} elseif {$stimIdx == 4} {
		    dl_put $change_stim $i 21
		}  elseif {$stimIdx == 5} {
		    dl_put $change_stim $i 22
		} elseif {$stimIdx == 6} {
		    dl_put $change_stim $i 23
		} elseif {$stimIdx == 7} {
		    dl_put $change_stim $i 24
		} elseif {$stimIdx == 8} {
		    dl_put $change_stim $i 25
		} elseif {$stimIdx == 9} {
		    dl_put $change_stim $i 26
		} elseif {$stimIdx == 10} {
		    dl_put $change_stim $i 27
		} elseif {$stimIdx == 11} {
		    dl_put $change_stim $i 28
		} elseif {$stimIdx == 12} {
		    if {$b == 1} {
			dl_put $change_stim $i 5
		    } elseif {$b == 2} {
			dl_put $change_stim $i 29
		    } elseif {$b == 3} {
			dl_put $change_stim $i 8
		    } elseif {$b == 4} {
			dl_put $change_stim $i 12
		    }
		} elseif {$stimIdx == 13} {
		    if {$b == 1} {
			dl_put $change_stim $i 6
		    } elseif {$b == 2} {
			dl_put $change_stim $i 30
		    } elseif {$b == 3} {
			dl_put $change_stim $i 10
		    } elseif {$b == 4} {
			dl_put $change_stim $i 13
		    }
		} elseif {$stimIdx == 14} {
		    if {$b == 1} {
			dl_put $change_stim $i 7
		    } elseif {$b == 2} {
			dl_put $change_stim $i 31
		    } elseif {$b == 3} {
			dl_put $change_stim $i 11
		    } elseif {$b == 4} {
			dl_put $change_stim $i 14
		    }
		} elseif {$stimIdx == 15} {
		    if {$b == 1} {
			dl_put $change_stim $i 35
		    } elseif {$b == 2} {
			dl_put $change_stim $i 32
		    } elseif {$b == 3} {
			dl_put $change_stim $i 18
		    } elseif {$b == 4} {
			dl_put $change_stim $i 15
		    }
		} elseif {$stimIdx == 16} {
		    if {$b == 1} {
			dl_put $change_stim $i 36
		    } elseif {$b == 2} {
			dl_put $change_stim $i 33
		    } elseif {$b == 3} {
			dl_put $change_stim $i 19
		    } elseif {$b == 4} {
			dl_put $change_stim $i 16
		    }
		} elseif {$stimIdx == 17} {
		    if {$b == 1} {
			dl_put $change_stim $i 37
		    } elseif {$b == 2} {
			dl_put $change_stim $i 34
		    } elseif {$b == 3} {
			dl_put $change_stim $i 20
		    } elseif {$b == 4} {
			dl_put $change_stim $i 17
		    }
		}
	    }
	    if {$b == 0} {
		set first_block_stim $change_stim
	    } elseif {$b == 1} {
		set dev1_block_stim $change_stim
	    } elseif {$b == 2} {
		set dev2_block_stim $change_stim
	    } elseif {$b == 3} {
		set dev3_block_stim $change_stim
	    } elseif {$b == 4} {
		set dev4_block_stim $change_stim
	    }
	}

    }
        
    dl_set stimdg:version [dl_slist [namespace current]]
    dl_set stimdg:block_n [dl_ilist]
    dl_set stimdg:block_id [dl_ilist]
        ###Makes the actual total list with the correct number of ids
    for {set i 0} {$i < [dl_llength $block_type]} {incr i} {
	set blocktypeid [dl_get $block_type $i]
	if {$blocktypeid != 0} {
	    dl_set stimdg:block_id [dl_combine stimdg:block_id [dl_repeat $blocktypeid $imgPerBlock]]
	} elseif {$blocktypeid == 0} {
	    dl_set stimdg:block_id [dl_append stimdg:block_id $blocktypeid]
	}
    }

    ########## Set deviant types on list according to block_id #######
    # Dev 1 = ; Dev2 = ; Dev3 = ; Dev4 = ;
   
    set nblocks [expr $numBlocksEachCond*2]
    dl_local block_n [dl_fromto 0 $nblocks]
    dl_local repeat_n \
        [dl_replicate [dl_ilist $imgPerBlock 1] $numBlocksEachCond]
    dl_set stimdg:block_n [dl_repeat $block_n $repeat_n]
    ###Place actual names of each stimtype next to its id
    dl_set stimdg:block_type [dl_repeat [dl_slist null] [dl_llength stimdg:block_id]]
    for {set i 0} {$i < [dl_llength stimdg:block_id]} {incr i} {
	set stimid [lindex [dl_tcllist stimdg:block_id] $i]
	if {$stimid == 1} {
	    if {$block_order == 0} {
		dl_put stimdg:block_type $i "AAAA"
	    } else {
		dl_put stimdg:block_type $i "AAAB"
	    }
	} elseif {$stimid == 2} {
	    dl_put stimdg:block_type $i "Dev1"
	} elseif {$stimid == 3} {
	    dl_put stimdg:block_type $i "Dev2"
	} elseif {$stimid == 4} {
	    dl_put stimdg:block_type $i "Dev3"
	} elseif {$stimid == 5} {
	    dl_put stimdg:block_type $i "Dev4"
	} elseif {$stimid == 0} {
	    dl_put stimdg:block_type $i "fixation"	    
	}; #End of if else
    }; #End of for loop

    #####Expanding each list to set them on stimdg##########
    ####Expand for stim type list

    
    set exphabittimes [dl_append [dl_repeat $first_block 4] 0]
    set exphabit [dl_append [dl_repeat $first_block_stim 4] 0]

    set dev1_time_rep [dl_repeat "9" [dl_llength $dev1_block]]

    for {set i 0} {$i < [dl_llength $dev1_block]} {incr i} {
	set timeval [lindex [dl_tcllist $dev1_block] $i]
	if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
	    dl_put $dev1_time_rep $i 4
	} elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
	    dl_put $dev1_time_rep $i 2
	} elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
	    dl_put $dev1_time_rep $i 6
	}
    }
    set expdev1times [dl_append [dl_repeat $dev1_block $dev1_time_rep] 0]
    
    set expdev1 [dl_append [dl_repeat $dev1_block_stim $dev1_time_rep] 0]


    set dev3_time_rep [dl_repeat "9" [dl_llength $dev3_block]]

    for {set i 0} {$i < [dl_llength $dev3_block]} {incr i} {
	set timeval [lindex [dl_tcllist $dev3_block] $i]
	if {[dl_get [dl_oneof $timeval "1 2 3 4 5 6"] 0] == 1} {
	    dl_put $dev3_time_rep $i 4
	} elseif {[dl_get [dl_oneof $timeval "7"] 0] == 1} {
	    dl_put $dev3_time_rep $i 2
	} elseif {[dl_get [dl_oneof $timeval "8"] 0] == 1} {
	    dl_put $dev3_time_rep $i 6
	}
    }

    set expdev3times [dl_append [dl_repeat $dev3_block $dev3_time_rep] 0]
    
    set expdev3 [dl_append [dl_repeat $dev3_block_stim $dev3_time_rep] 0]

    #Expand dev 2
    set expdev2 [dl_append [dl_repeat $dev2_block_stim 4] 0]
    set expdev2times [dl_append [dl_repeat $dev2_block 4] 0]
    #Aaaand now exp dev4 same way
    set expdev4 [dl_append [dl_repeat $dev4_block_stim 4] 0]
    set expdev4times [dl_append [dl_repeat $dev4_block 4] 0]

        ###Combine lists to get stim_types on stimdg
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id] 
    dl_set stimdg:stim_types [dl_ilist]
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $exphabit]
	} elseif { $idtestvals == 2 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev1]
	} elseif { $idtestvals == 3 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev2]
	} elseif { $idtestvals == 4 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev3]
	} elseif { $idtestvals == 5 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $expdev4]
	}; #end of if else#
    }; #end of foreach

        set uq_stimtestids [dl_uniqueNoSort stimdg:block_id] 
    dl_set stimdg:on_type [dl_ilist]
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $exphabittimes]
	} elseif { $idtestvals == 2 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev1times]
	} elseif { $idtestvals == 3 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev2times]
	} elseif { $idtestvals == 4 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev3times]
	} elseif { $idtestvals == 5 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type $expdev4times]
	}; #end of if else#
    }; #end of foreach


    #Assign images according to stim_id. Go through the ID list and place images.
    #Depending on trial type img assignments will vary (AAAA or AAAB).
    #Current code is redundant, need to come back to it and fix.

    dl_set stimdg:stimcountlist [dl_repeat "9" [dl_llength stimdg:stim_types]]
    set tasktrials [dl_llength stimdg:stim_types]
    
    dl_set stimdg:stimuli [dl_repeat [dl_slist null] $tasktrials]
    
    if {$block_order == 0} {
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
        
	    if {$stimIdx == 1} {
		dl_put stimdg:stimuli $i $img1
	    } elseif {$stimIdx == 2} {
		dl_put stimdg:stimuli $i $img2
	    } elseif {$stimIdx == 3} {
		dl_put stimdg:stimuli $i $img3
	    } elseif {$stimIdx == 4} {
		dl_put stimdg:stimuli $i $img4
	    } elseif {$stimIdx == 5} {
		dl_put stimdg:stimuli $i $img5          
	    } elseif {$stimIdx == 6} {
		dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 7} {
		dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 8} {
		#5-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 10} {
	    #6-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 11} {
		#7-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
		#5-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 19} {
		#6-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 20} {
		#7-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
		dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 13} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 14} {
		if {$imgcount == 4} {        
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}            
	    } elseif {$stimIdx == 15} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 16} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}        
	    } elseif {$stimIdx == 17} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}        
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
        
	}; #End of for loop assigning imgs
    } else {
	
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
	    #Will have individual id for each habit combination
	    
	    if {$stimIdx == 1} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 2} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 3} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 4} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 11} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 21} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img2
		}          
	    } elseif {$stimIdx == 22} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 23} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 24} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 25} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 26} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img4
		}          
	    } elseif {$stimIdx == 27} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 28} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 29} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 30} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 31} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 32} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 33} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}
	    } elseif {$stimIdx == 34} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}		
	    } elseif {$stimIdx == 5} {
		#5-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 6} {
		#5-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 7} {
		#6-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 8} {
	        dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 10} {
		dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 36} {
		#7-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
	        dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 19} {
	        dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 20} {
	        dl_put stimdg:stimuli $i $img7		
	    } elseif {$stimIdx == 35} {
		#6-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 37} {
		#7-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
		dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
	        dl_put stimdg:stimuli $i $img5
		
	    } elseif {$stimIdx == 13} {
		dl_put stimdg:stimuli $i $img5
        
	    } elseif {$stimIdx == 14} {
		dl_put stimdg:stimuli $i $img6
	               
	    } elseif {$stimIdx == 15} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 16} {
		dl_put stimdg:stimuli $i $img7
		       
	    } elseif {$stimIdx == 17} {
		dl_put stimdg:stimuli $i $img7
		      
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
	}; #End of for loop assigning imgs
    }; #End of if else statement

    # Reward
    # ------
    # Grab rewardDuration from the (quick)params
    # set reward_amount 250
    # dl_set stimdg:rewardDuration [dl_repeat $reward_amount $ntrials]

    set ntrials [dl_llength stimdg:block_id]
    dl_set stimdg:rwdInt_max [dl_repeat $rwdInt_max $ntrials]
    dl_set stimdg:rwdInt_min [dl_repeat $rwdInt_min $ntrials]
    dl_set stimdg:rwdInt_inc [dl_repeat $rwdInt_inc $ntrials]
    dl_set stimdg:rwdInt_n [dl_repeat $rwdInt_n $ntrials]

    # Want the fixation spot present for all the trials
    dl_set stimdg:fixPresent [dl_repeat $fixPresent $ntrials]
    dl_set stimdg:background_luminance [dl_repeat $bgLuminance $ntrials]

    # Stimuli on times
    # ----------------
    # Right now the times are generated using matlab code and lives in the following folder:
    # L:\projects\stimulator2\mri\N_localizers\pseq_itis
    # What is going on here: Grab the column with the time info, use the id assigned in the ORIGINAL doc
    # to identify the ITI that will correspond to the now shuffled blocks. Assign the corresponding vals.
    # Use iti column and blockid column in file
    # dl_set stimdg:blockid $table_blockid

    #Set the itis column to a variable

    set some_itis $pseq_file:iti
    set isp $pseq_file:isp
    #Put together iti and ISP column
    #First, find idxs of isps
    set isp_idx [dl_findAll [dl_not $isp] 0]
    #Using these idxs match vals in the iti list to replace 0 vals for isps
    #Get list of values using idxs
    set isp_vals [dl_choose $isp $isp_idx]
    #Use isp vals and isp_idxs to replace in iti list
    set itis [dl_replaceByIndex $some_itis $isp_idx $isp_vals]
    
    set itis_length [dl_length $itis]
    #Set vars for each block that will contain each iti depending on id and deviant type
    
    set habit_block_itis [dl_float [dl_repeat 9 $itis_length] ]
    set numdev_block_itis [dl_float [dl_repeat 9 $itis_length] ]
    set newexp_block_itis [dl_float [dl_repeat 9 $itis_length] ]
    set numpat_block_itis [dl_float [dl_repeat 9 $itis_length] ]
    set patdev_block_itis [dl_float [dl_repeat 9 $itis_length] ]

    #Loop through block id's and get iti vals

    for {set i 0} { $i < $itis_length } {incr i} {

	set table_blockid_val [dl_get $table_blockid $i]

	if {$table_blockid_val == 1} {

	    set habit_iti [dl_get $itis $i]

	    dl_put $habit_block_itis $i $habit_iti
	    
	} elseif {$table_blockid_val == 2} {

	    set numdev_iti [dl_get $itis $i]

	    dl_put $numdev_block_itis $i $numdev_iti
	    
	} elseif {$table_blockid_val == 3} {

	    set newexp_iti [dl_get $itis $i]

	    dl_put $newexp_block_itis $i $newexp_iti

	} elseif {$table_blockid_val == 4} {

	    set numpat_iti [dl_get $itis $i]

	    dl_put $numpat_block_itis $i $numpat_iti
	    
	} elseif {$table_blockid_val == 5} {

	    set patdev_iti [dl_get $itis $i]

	    dl_put $patdev_block_itis $i $patdev_iti
	    
	}; #end of if else statement
    }; #end of for loop

    #Now that have vals put them in the right order (these will be the off_times)
    #Remove 9's first and append 0 (fix time) at end of each list.

    set habit_itis [dl_append [dl_select $habit_block_itis [dl_findAll [dl_noteq $habit_block_itis 9] 1] ] 0]
    set numdev_itis [dl_append [dl_select $numdev_block_itis [dl_findAll [dl_noteq $numdev_block_itis 9] 1] ] 0]
    set newexp_itis [dl_append [dl_select $newexp_block_itis [dl_findAll [dl_noteq $newexp_block_itis 9] 1] ] 0]
    set numpat_itis [dl_append [dl_select $numpat_block_itis [dl_findAll [dl_noteq $numpat_block_itis 9] 1] ] 0]
    set patdev_itis [dl_append [dl_select $patdev_block_itis [dl_findAll [dl_noteq $patdev_block_itis 9] 1] ] 0]
    
    # Put the list together using current shuffled order

            ###Combine lists to get stim_types on stimdg
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id]
    
    set off_Sec [dl_flist]
    
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    set off_Sec [dl_combine $off_Sec $habit_itis]
	} elseif { $idtestvals == 2 } {
	    set off_Sec [dl_combine $off_Sec $numdev_itis]
	} elseif { $idtestvals == 3 } {
	    set off_Sec [dl_combine $off_Sec $newexp_itis]
	} elseif { $idtestvals == 4 } {
	    set off_Sec [dl_combine $off_Sec $numpat_itis]
	} elseif { $idtestvals == 5 } {
	    set off_Sec [dl_combine $off_Sec $patdev_itis]
	}; #end of if else#
    }; #end of foreach

    # Set the Ontimes only since offtimes are already set
    set totalon_type stimdg:on_type
    
    set on_Sec [dl_repeat 0.1 [dl_llength $totalon_type]]
    dl_set stimdg:countlist [dl_repeat "9" [dl_llength $totalon_type]]
    
        
    for {set i 0} { $i < [dl_llength $totalon_type] } { incr i} {

        if {$i == 0} {
        set count 1
        } 
        
        dl_put stimdg:countlist $i $count 
        set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
        set onstimIdx [lindex [dl_tcllist $totalon_type] $i]
        
        if {$onstimIdx == 1} {
	    dl_put $on_Sec $i 0.1
        
        } elseif {$onstimIdx == 2} {
	    dl_put $on_Sec $i 0.2

        } elseif {$onstimIdx == 3} {
	    dl_put $on_Sec $i 0.3

        } elseif {$onstimIdx == 4} {
	    dl_put $on_Sec $i 0.1

        } elseif {$onstimIdx == 5} {
	    dl_put $on_Sec $i 0.2

        } elseif {$onstimIdx == 6} {
	    dl_put $on_Sec $i 0.3
 
        } elseif {$onstimIdx == 7} {
	    dl_put $on_Sec $i 0.2

        } elseif {$onstimIdx == 8} {
	    dl_put $on_Sec $i 0.2

        } elseif {$onstimIdx == 10} {
	    dl_put $on_Sec $i 0.2

        } elseif {$onstimIdx == 11} {
	    dl_put $on_Sec $i 0.2

        } elseif {$onstimIdx == 0} {
	    dl_put $on_Sec $i 14.0
        }; #end if/else statement
        

        set count [expr $count+1]

        if {$i < [expr [dl_llength $totalon_type]-1]} {
        
            if {[dl_get $totalon_type $i] != [dl_get $totalon_type [expr $i+1]]} {
            set count 1
            }
        }
        

    }; #end for loop

        
    set restofonsec [dl_repeat 0.1 [expr $ntrials - [dl_llength $on_Sec]]]
    
    set stimOnDur [dl_combine $on_Sec $restofonsec]
    dl_set stimdg:on_type $totalon_type

    set restofoffsec [dl_repeat 0.1 [expr $ntrials - [dl_llength $on_Sec]]]
    set stimOffDur [dl_prepend [dl_combine $off_Sec $restofoffsec] 0]

    # Figure out how long each frame is based on refresh rate
    # FrameDuration ;# gives answer in *ms*
    set screenHz [screen_set RefreshRate] ;# frames/sec
    # For debugging in tcl
    #set screenHz 60
    
    #### 
    dl_set stimdg:onSec [dl_repeat 0.1 $ntrials]
    dl_set stimdg:offSec [dl_repeat 0.1 $ntrials]
    # Initialize the columns for frame numbers (always integers)
    dl_set stimdg:onFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:offFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:endFrameN [dl_repeat 0 $ntrials]

    
    for { set i 0 } { $i < $ntrials } { incr i } {
        # Have a choice, can either calculate the times and attempt
        #  to get the frames right, or can calculate the frames, and 
        #  calculate the times accordingly.
        # This is frame-based

        #onSec
        #-----
        if {$i == 0} {
        # First trial
        #dl_put stimdg:onSec $i 0
        dl_put stimdg:onFrameN $i 0
        } else {
        # previous block type
        set prev_block_type [lindex [dl_tcllist stimdg:block_type] \
                     [expr $i - 1]]
        
        # Set the frames, by prev block type
        if { $prev_block_type == "fixation" } {
            set prevOffFrames 0
        } else {
            # round because frames must be integers
            set prevOffFrames [expr round([dl_get $stimOffDur $i] * $screenHz)]
        }

        #onFrameN = previous trial offFrame + 
        #           prevOffFrames (duration in frames)
        dl_put stimdg:onFrameN $i \
            [expr [lindex [dl_tcllist stimdg:offFrameN] [expr $i - 1]] \
             + $prevOffFrames]

        # Also set the previous end frame. 
        #  Repeats info, but keeps the iti explicit
        dl_put stimdg:endFrameN [expr $i - 1] \
            [dl_get stimdg:onFrameN $i]
        }
        # Calculate the corresponding on time in seconds
        dl_put stimdg:onSec $i \
        [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
             / ($screenHz + 0.0)] ;#intro floating point

        #offSec
        #------
        # Get the current block type, fixation or otherwise
        set block_type [lindex [dl_tcllist stimdg:block_type] $i] 

        # Set the frames, by block type (note != not equal)
        #  round because frames must be integers
        if { $block_type == "fixation" } {
        set currOnFrames [expr round($fixBlockDur * $screenHz)]
        } else {  
        # Not fixation. Make it calculate for each of the 3 possible ON values
        set currOnFrames [expr round([dl_get $stimOnDur $i] * $screenHz)]
        
        }
        
        # offFrameN = onFrameN + currOnFrames (dur in frames)
        # Brings up an error if like this
        
        dl_put stimdg:offFrameN $i \
        [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
             + $currOnFrames]
        
        # Calculate the corresponding off time in seconds
        dl_put stimdg:offSec $i \
        [expr [lindex [dl_tcllist stimdg:offFrameN] $i] \
             / ($screenHz + 0.0)] ;#intro floating point
	
	set lasttrial [dl_last $ntrials]

	### Fixed so that last frame and endframe match
	
	if {$i == [expr $lasttrial-1] } {
	    dl_put stimdg:endFrameN $i [dl_last stimdg:offFrameN]
	}
    } ;#end trial loop
    
    if { [dl_sum [dl_find [dl_eq stimdg:stimcountlist 7] 1]] >= 1 } { error "fatal seq repeat, pick again" }
   
    dl_set stimdg:itis $itis

};#end proc jitter_pseq

proc habit_only { monkey session block_order \
			   rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
	set maxtries 100
	for { set tries 0 } { $tries < $maxtries } { incr tries } {
	    if { [catch { try_habit_only $monkey $session $block_order \
			      $rwdInt_max $rwdInt_min \
 			      $rwdInt_inc $rwdInt_n } ] == 0 } break
 	} 
 	if { $tries == $maxtries } { error "unable to find sequence" }
     }
    
proc try_habit_only  { monkey session block_order \
			   rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
    set numBlocksEachCond 4
    set imgPerBlock 120
    set fixBlockDur 14
    set fixPresent 1 ;#fix spot present for everything
    set bgLuminance 255
    set fixation 0
    set stimOnDur 0.2
    #Set paths for images
    
    if [file exists c:/stimuli/MRILocalizers] {
        set mripath c:/stimuli/MRILocalizers
    } else {
        set mripath ../stimuli/MRILocalizers
    }

    dl_local imgFolders [eval dl_slist $mripath/scramobjects \
			     fixation]
    
    #Basics: Making sure stimdg exists and some defaults
    # Need to add fixation and figure the right way of getting out of dl
    set img_groups [dl_tcllist [dl_filebase $imgFolders]]
    set fixblocknum [lsearch $img_groups "fixation"]

          # Figure out the total number of stim/images that will need of each kind
    set nTotImg [expr $numBlocksEachCond * $imgPerBlock]
            
    # Ok, so let's try to make stimdg exist
    # stimdg
    # ------
    if {[dg_exists stimdg]} {
        dg_delete stimdg
    }

    dg_create stimdg

    dl_set stimdg:version [dl_slist [namespace current]]
 
    dl_set stimdg:block_n [dl_ilist]
    dl_set stimdg:block_id [dl_ilist]
    

    # For this version of the task the 2 deviant blocks will be shuffled
    # (just order of appearance of block, not internally)
    #First make a simple that has the id's you want. Here habit will be 1, short and long dev 2
    #medium dev 3, novel block 4
    dl_local habit [dl_ilist 1]
    set block_type [dl_concat [dl_combine $fixation $habit] $fixation]

    ###Makes the actual total list with the correct number of ids
    for {set i 0} {$i < [dl_llength $block_type]} {incr i} {
	set blocktypeid [dl_get $block_type $i]
	#Cycle through block type ids and expand non zero values according to total amt of images
	#(set on imgPerBlock)
	
	if {$blocktypeid != 0} {
	    dl_set stimdg:block_id [dl_combine stimdg:block_id [dl_repeat $blocktypeid $imgPerBlock]]
	} elseif {$blocktypeid == 0} {
	    dl_set stimdg:block_id [dl_append stimdg:block_id $blocktypeid]
	}
    }
    
    # Create column for block number (block_n)
    #set nblocks [expr $numBlocksEachCond*2]
    dl_set stimdg:block_n [dl_repeat "0 1 2" "1 120 1"]

    ###Place actual names of each stimtype next to its id
    
    dl_set stimdg:block_type [dl_repeat [dl_slist null] [dl_llength stimdg:block_id]]
    if {$block_order == 0} {
	for {set i 0} {$i < [dl_llength stimdg:block_id]} {incr i} {
	    set stimid [lindex [dl_tcllist stimdg:block_id] $i]
	    if {$stimid == 1} {
		dl_put stimdg:block_type $i "AAAA"
	    } elseif {$stimid == 0} {
		dl_put stimdg:block_type $i "fixation"	    
	    }; #End of if else
	}; #End of for loop
    } else {
	for {set i 0} {$i < [dl_llength stimdg:block_id]} {incr i} {
	    set stimid [lindex [dl_tcllist stimdg:block_id] $i]
	    if {$stimid == 1} {
		dl_put stimdg:block_type $i "AAAB"
	    } elseif {$stimid == 0} {
		dl_put stimdg:block_type $i "fixation"	    
	    }; #End of if else
	}; #End of for loop
    }; #end of elseif for assigning block type name

    ###Continuing here NYR 9/20/2018
    ###Now bring up images. For now still using the same 4 that have been using for habituation. This will change when we decide on fractals or blobs

        #call images to place and use later
    set filefolder ../stimuli/MRILocalizers/fractals/
    set ext .png ;#name of extension of image
    #set filename $basefile${filenum}${ext}; #example to combine pieces
    set filename "_fractal_"
    
    for {set i 1} {$i < 5} {incr i} {
	set img$i $filefolder${session}${filename}${i}${ext}
    }
    

    #9/24/2018
    #Image order will be chosen the way it is chosen on pseq code.
    #Except now only have to happen for 1 block. Additionally, only choosing id for identity of stimuli since now there is no specific timing for sequences, only ITI's generated by DB.
    
    set uq_block_id [dl_unique stimdg:block_id]
    
    for {set i 0} {$i < [dl_llength $uq_block_id]} {incr i} {
        
        set block_id_idx [dl_get $uq_block_id $i]
        
	if {$block_id_idx == 1} {
	    if {$block_order == 0} {
		set nstim 28
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_repeat "1 2 3 4" 7]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_select "1 2 3 4 21 22 23 24 25 26 27 28" [dl_randchoose 12 6]]]
		set stim_array [dl_repeat 9 $nstim]
	    }
        } elseif {$block_id_idx == 2} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 5 6 7 35 36 37]]
		set stim_array [dl_repeat 9 $nstim]
	    }
	} elseif {$block_id_idx == 3} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 29 30 31 32 33 34]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	} elseif {$block_id_idx == 4} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	    
	} else {
	    if {$block_order == 0} {
	    set nstim 30
            set stim_used [dl_zeros $nstim]
            set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	}
    #Find the next position to fill in
    
        set stim_idx [dl_findAll $stim_array "9"]

    #Go through each idx line individually  
        foreach stimline [dl_tcllist $stim_idx] {
        #First line can be any habituation item
	    if {$stimline == 0} {
            #First stim. Find habit indices
	    #####
	    set habitindices [dl_oneof $poss_stim "1 2 3 4 21 22 23 24 25 26 27 28"]
	    set habit_match [dl_not [dl_and $habitindices [dl_not $stim_used] ] ]
	    #####
            #Find available stimuli
            set avail_stimidxs [dl_findAll $habit_match 0]
	    #set avail_stimidxs [dl_findAll $stim_used 0]
            #Choose randomly one of the available stimuli can use dl_pickone
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            
            dl_put $stim_array $stimline $actual_stim
            #This next put will mark the item in the zeros as used
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
	    #First part logic is sound. Always gives you a new num and marks it where it should be.
	} elseif {[dl_get [dl_oneof $stimline "1 2 3 4 5"] 0] == 1} {
	    set laststim [dl_get $stim_array $lastLine]
	    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]]\
						[dl_not [dl_oneof $poss_stim\
							     "5 6 7 35 36 37 29 30 31 32 33 34\
							     8 10 11 18 19 20 12 13 14 15 16 17"]]] "1"]
	    
	    set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
	    
        } else {
            #Find the available stimuli that are not the previous stimuli
            set laststim [dl_get $stim_array $lastLine]
	    
	    if {$block_order == 0} {
		#If it's stims 1 2 3 4 then it's fine to choose any
		if {[dl_get [dl_oneof $laststim "1 2 3 4"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]] "1"]
		    
		} elseif {[dl_get [dl_oneof $laststim "8 10 11 18 19 20"] 0] == 1} {
		    #Choose so devs don't follow each other (for all other conds)
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "8 10 11 18 19 20"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "5 6 7"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "5 6 7"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "12 13 14 15 16 17"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "12 13 14 15 16 17"]]] "1"]
		}
		
	    } else {
		#Ask to check for last again cause otherwise doesn't find it
		set laststim [dl_get $stim_array $lastLine]
		#Make sure that the ones that start with 1 aren't chosen
		if {[dl_get [dl_oneof $laststim "4 23 26"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
						        [dl_not [dl_oneof $poss_stim "1 2 3"]]] "1"]
		    #Make sure that the ones that start with 2 aren't chosen
		} elseif {[dl_get [dl_oneof $laststim "1 24 27"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "4 21 22"]]] "1"]
		    #Make sure that the ones that start with 3 aren't chosen
		} elseif {[dl_get [dl_oneof $laststim "2 21 28"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "23 24 25"]]] "1"]
		    #Make sure that the ones that start with 4 aren't chosen		    
		} elseif {[dl_get [dl_oneof $laststim "3 22 25"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "26 27 28"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "8 10 11 18 19 20"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "8 10 11 18 19 20"]]] "1"]
		    ##Added these lines because was still getting deviants one after the other
		} elseif {[dl_get [dl_oneof $laststim "5 6 7 35 36 37"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "5 6 7 35 36 37"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "12 13 14 15 16 17"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "12 13 14 15 16 17"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "29 30 31 32 33 34"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "29 30 31 32 33 34"]]] "1"]		    
		} else {
		    set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]] "1"]
		}
	    }

            if {[dl_llength $avail_stimidxs] == 0} {
        #Set list to 0 and pick first stim again
            set stim_used [dl_zeros $nstim]
            set avail_stimidxs [dl_findAll $stim_used 0]
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            dl_put $stim_array $stimline $actual_stim
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
                } else {
                if {[dl_llength $avail_stimidxs] > 1} {
                set chosen_idx [dl_pickone $avail_stimidxs]
                } else {
                set chosen_idx $avail_stimidxs
                }
            }
            
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
        }; #End of if else
        
        }; #End of Foreach
        
        if {$block_id_idx == 1} {
	    if {$block_order == 0} {
	    set first_block $stim_array
	    set laststimidx [dl_not [dl_oneof "1 2 3 4" [dl_last $first_block]]]
	    set first_extra [dl_pickone [dl_select "1 2 3 4" $laststimidx]]
	    set first_extraidx [dl_not [dl_oneof "1 2 3 4" $first_extra]]
	    set both_extra [dl_combine $first_extra [dl_pickone [dl_select \
								     "1 2 3 4" $first_extraidx]]]
	    set habit_block [dl_combine $first_block $both_extra]
	    } else {
		set habit_block $stim_array
	    }
	    
        } elseif {$block_id_idx == 2} {
	    set dev1_block $stim_array
	} elseif {$block_id_idx == 3} {
	    set dev2_block $stim_array
	} elseif {$block_id_idx == 4} {
	    set dev3_block $stim_array
	} elseif {$block_id_idx == 5} {
	    set dev4_block $stim_array
	}
    }; #End of for loop
    
    
    #Now that have ids, expand lists and add fixation block id's (0) at beginning and end of list
    #Expand first. Same as for other versions of passive seq
    #Repeat values for either type by 4.
    #Substitution of 4th item in images for AAAB type will happen during stimulus assignment.
    
    #This is for AAAA habit type seq
    set exphabit [dl_prepend [dl_append [dl_repeat $habit_block 4] 0] 0]

    dl_set stimdg:stim_types $exphabit

    #Now assign images for stimuli
    
        set totalon_type stimdg:stim_types
    #So far so good...
      dl_set stimdg:stimcountlist [dl_repeat "9" [dl_llength stimdg:stim_types]]
    set tasktrials [dl_llength stimdg:stim_types]
    
    dl_set stimdg:stimuli [dl_repeat [dl_slist null] $tasktrials]
    
    if {$block_order == 0} {
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
        
	    if {$stimIdx == 1} {
		dl_put stimdg:stimuli $i $img1
	    } elseif {$stimIdx == 2} {
		dl_put stimdg:stimuli $i $img2
	    } elseif {$stimIdx == 3} {
		dl_put stimdg:stimuli $i $img3
	    } elseif {$stimIdx == 4} {
		dl_put stimdg:stimuli $i $img4      
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
        
	}; #End of for loop assigning imgs
    } else {
	
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
	    #Will have individual id for each habit combination
	    
	    if {$stimIdx == 1} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 2} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 3} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 4} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 11} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 21} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img2
		}          
	    } elseif {$stimIdx == 22} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 23} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 24} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 25} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 26} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img4
		}          
	    } elseif {$stimIdx == 27} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 28} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 29} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 30} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 31} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 32} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 33} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}
	    } elseif {$stimIdx == 34} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}		
	    } elseif {$stimIdx == 5} {
		#5-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 6} {
		#5-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 7} {
		#6-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 8} {
	        dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 10} {
		dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 36} {
		#7-5 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
	        dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 19} {
	        dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 20} {
	        dl_put stimdg:stimuli $i $img7		
	    } elseif {$stimIdx == 35} {
		#6-7 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 37} {
		#7-6 pair
		if {[dl_get stimdg:on_type $i] == 7} {
		    if {$imgcount == 2} {
		dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get stimdg:on_type $i] == 8} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
	        dl_put stimdg:stimuli $i $img5
		
	    } elseif {$stimIdx == 13} {
		dl_put stimdg:stimuli $i $img5
        
	    } elseif {$stimIdx == 14} {
		dl_put stimdg:stimuli $i $img6
	               
	    } elseif {$stimIdx == 15} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 16} {
		dl_put stimdg:stimuli $i $img7
		       
	    } elseif {$stimIdx == 17} {
		dl_put stimdg:stimuli $i $img7
		      
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
	}; #End of for loop assigning imgs
    }; #End of if else statement for block_order selection
    # Once have the basics of stimdg, want the on and off time of every line
    set ntrials [dl_llength stimdg:block_id]

    # Figure out how long each frame is based on refresh rate
    # FrameDuration ;# gives answer in *ms*
    set screenHz [screen_set RefreshRate] ;# frames/sec
    # For debugging in tcl
    #set screenHz 60

    
    # Reward
    # ------
    # Grab rewardDuration from the (quick)params
    # set reward_amount 250
    # dl_set stimdg:rewardDuration [dl_repeat $reward_amount $ntrials]

    dl_set stimdg:rwdInt_max [dl_repeat $rwdInt_max $ntrials]
    dl_set stimdg:rwdInt_min [dl_repeat $rwdInt_min $ntrials]
    dl_set stimdg:rwdInt_inc [dl_repeat $rwdInt_inc $ntrials]
    dl_set stimdg:rwdInt_n [dl_repeat $rwdInt_n $ntrials]

    # Want the fixation spot present for all the trials
    dl_set stimdg:fixPresent [dl_repeat $fixPresent $ntrials]
    dl_set stimdg:background_luminance [dl_repeat $bgLuminance $ntrials]

    # Fixwin setting
    # -----
    #Not necessary for this protocol, but left the option there in case we choose to use it. 
    #dl_set stimdg:fixwinRadius [dl_repeat $fixwin_radius $ntrials]

    # Times (obj_loc)
    # -----

    # Loop through all the "trials"
    # Assign start and stop times, in seconds, for each line
    # Initialize the colums for times
    #   Initialize to a decimal otherwise get an error when try to assign
    dl_set stimdg:onSec [dl_repeat 0.1 $ntrials]
    dl_set stimdg:offSec [dl_repeat 0.1 $ntrials]
    # Initialize the columns for frame numbers (always integers)
    dl_set stimdg:onFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:offFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:endFrameN [dl_repeat 0 $ntrials]

    #Now add in the column that has the stimulus ITI infScan_seqo
    #First load in the table containing the ITI columns
    
    dg_read mri/Scan_seq/habit_itis/habit_only_itis.dgz

    ######## This will be made so that it chooses randomly from 20 columns of time.
    set col [dl_pickone [dl_fromto 0 20]]
    set iti_vals [dl_select habit_only_itis:$col [dl_fromto 0 [dl_length stimdg:block_n] ]]
    set stimOffDur $iti_vals
    
    for { set i 0 } { $i < $ntrials } { incr i } {
	# Have a choice, can either caluculate the times and attempt
	#  to get the frames right, or can calculate the frames, and 
	#  calculate the times accordingly.
	# This is frame-based

	#onSec
	#-----
	if {$i == 0} {
	    # First trial
	    #dl_put stimdg:onSec $i 0
	    dl_put stimdg:onFrameN $i 0
	} else {
	    # previous block type
	    set prev_block_type [lindex [dl_tcllist stimdg:block_type] \
				     [expr $i - 1]]
	    
	    # Set the frames, by prev block type
	    if { $prev_block_type == "fixation" } {
		set prevOffFrames 0

	    } else {
		# round because frames must be integers
		set prevOffFrames [expr round([dl_get $stimOffDur $i] * $screenHz)]
	    }

	    #onFrameN = previous trial offFrame + 
	    #           prevOffFrames (duration in frames)
	    dl_put stimdg:onFrameN $i \
		[expr [lindex [dl_tcllist stimdg:offFrameN] [expr $i - 1]] \
		     + $prevOffFrames]

	    # Also set the previous end frame. 
	    #  Repeats info, but keeps the iti explicit
	    dl_put stimdg:endFrameN [expr $i - 1] \
		[dl_get stimdg:onFrameN $i]
	}
	# Calculate the corresponding on time in seconds
	dl_put stimdg:onSec $i \
	    [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
		 / ($screenHz + 0.0)] ;#intro floating point

	#offSec
	#------
	# Get the current block type, fixation or otherwise
	set block_type [lindex [dl_tcllist stimdg:block_type] $i] 

	# Set the frames, by block type (note != not equal)
	#  round because frames must be integers
	if { $block_type == "fixation" } {
	    set currOnFrames [expr round($fixBlockDur * $screenHz)]
	    
	} else {
	    # Not fixation
	    set currOnFrames [expr round($stimOnDur * $screenHz)]
	}
	
	# offFrameN = onFrameN + currOnFrames (dur in frames)
	dl_put stimdg:offFrameN $i \
	    [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
		 + $currOnFrames]
	
	# Calculate the corresponding off time in seconds
	dl_put stimdg:offSec $i \
	    [expr [lindex [dl_tcllist stimdg:offFrameN] $i] \
		 / ($screenHz + 0.0)] ;#intro floating point
	
	set lasttrial [dl_last $ntrials]

	### Fixed so that last frame and endframe match
	
	if {$i == [expr $lasttrial-1] } {
	    dl_put stimdg:endFrameN $i [dl_last stimdg:offFrameN]
	}
	
    } ;#end trial loop
    dl_set stimdg:ITIs $stimOffDur
    # For debugging
    #return stimdg
    if { [dl_oneof [dl_eq stimdg:stimcountlist 5] 1] == 1 } { error "fatal seq repeat, pick again" }
    dl_set stimdg:test [dl_eq stimdg:stimcountlist 5]
    if { [dl_sum [dl_find [dl_eq stimdg:stimcountlist 5] 1]] >= 1 } { error "fatal seq repeat, pick again" }
    
};#end proc habit_only

proc time_only  { monkey session block_order \
		     rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {

    set numBlocksEachCond 4
    set imgPerBlock 120
    set fixBlockDur 14
    set stimOnDur 0.2
    set fixPresent 1 ;#fix spot present for everything
    set bgLuminance 255
    set fixation 0
    #Set paths for images
    
    if [file exists c:/stimuli/MRILocalizers] {
        set mripath c:/stimuli/MRILocalizers
    } else {
        set mripath ../stimuli/MRILocalizers
    }

    dl_local imgFolders [eval dl_slist $mripath/scramobjects \
			     fixation]
    
    #Basics: Making sure stimdg exists and some defaults
    # Need to add fixation and figure the right way of getting out of dl
    set img_groups [dl_tcllist [dl_filebase $imgFolders]]
    set fixblocknum [lsearch $img_groups "fixation"]

          # Figure out the total number of stim/images that will need of each kind
    set nTotImg [expr $numBlocksEachCond * $imgPerBlock]
            
    # Ok, so let's try to make stimdg exist
    # stimdg
    # ------
    if {[dg_exists stimdg]} {
        dg_delete stimdg
    }

    dg_create stimdg

    dl_set stimdg:version [dl_slist [namespace current]]
 
    dl_set stimdg:block_n [dl_ilist]
    dl_set stimdg:block_id [dl_ilist]
    

    # For this version of the task the 2 deviant blocks will be shuffled
    # (just order of appearance of block, not internally)
    #First make a simple that has the id's you want. Here habit will be 1, short and long dev 2
    #medium dev 3, novel block 4
    dl_local habit [dl_ilist 1]
    dl_local deviants [dl_shuffle [dl_ilist 2 3]]
    dl_local novel [dl_ilist 4]
    set block_type [dl_interleave [dl_concat [dl_combine $habit $deviants] $novel] $fixation]

    ###Makes the actual total list with the correct number of ids
    for {set i 0} {$i < [dl_llength $block_type]} {incr i} {
	set blocktypeid [dl_get $block_type $i]
	#Cycle through block type ids and expand non zero values according to total amt of images
	#(set on imgPerBlock)
	
	if {$blocktypeid != 0} {
	    dl_set stimdg:block_id [dl_combine stimdg:block_id [dl_repeat $blocktypeid $imgPerBlock]]
	} elseif {$blocktypeid == 0} {
	    dl_set stimdg:block_id [dl_append stimdg:block_id $blocktypeid]
	}
    }
    
    # Create column for block number (block_n)
    set nblocks [expr $numBlocksEachCond*2]
    dl_local block_n [dl_fromto 0 $nblocks]
    dl_local repeat_n \
        [dl_replicate [dl_ilist $imgPerBlock 1] $numBlocksEachCond]
    dl_set stimdg:block_n [dl_repeat $block_n $repeat_n]

    ###Place actual names of each stimtype next to its id
    
    dl_set stimdg:block_type [dl_repeat [dl_slist null] [dl_llength stimdg:block_id]]
    for {set i 0} {$i < [dl_llength stimdg:block_id]} {incr i} {
	set stimid [lindex [dl_tcllist stimdg:block_id] $i]
	if {$stimid == 1} {
	    dl_put stimdg:block_type $i "Habituation"
	} elseif {$stimid == 2} {
	    dl_put stimdg:block_type $i "SLDeviant"
	} elseif {$stimid == 3} {
	    dl_put stimdg:block_type $i "MDeviant"
	} elseif {$stimid == 4} {
	    dl_put stimdg:block_type $i "Novel"
	} elseif {$stimid == 0} {
	    dl_put stimdg:block_type $i "fixation"	    
	}; #End of if else
    }; #End of for loop

    #Grab block vals from iti table 
    #Load file with Iti vals. Want to pick a random one from 20 options.
    #For now only using 1 because only 1 file exists

    set basefile mri/Scan_seq/time_seq_itis/time_iti ;#file folder
    set ext .dgz ;#name of extension of table
    #Add in remaining lists and list nums for random selection
    ####Fill out pickone list later when have more iti's
    set filenum [dl_pickone [dl_ilist 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20] ] ;#identifier in name of file
    set filename $basefile${filenum}${ext}; #combine pieces
    set time_file [dg_read $filename] ;#loads in table
    
    set table_blockid [dl_int $time_file:blockid]
    set timeid [dl_int $time_file:timeid]

    
    #call images to place and use later
   set filefolder ../stimuli/MRILocalizers/fractals/
    set ext .png ;#name of extension of image
    #set filename $basefile${filenum}${ext}; #example to combine pieces
    set filename "_fractal_"
    
    for {set i 1} {$i < 12} {incr i} {
	set img$i $filefolder${session}${filename}${i}${ext}
    }
    
    set table_blockid_length [dl_length $table_blockid]
    set time_vals [dl_int $time_file:timeid]
    # Get time values separately and expand later
   
    set habit_block_vals [dl_repeat 9 $table_blockid_length]
    set numdev_block_vals [dl_repeat 9 $table_blockid_length]
    set patdev_block_vals [dl_repeat 9 $table_blockid_length]
    set novel_block_vals [dl_repeat 9 $table_blockid_length]

    set new_novel_block_vals [dl_findAll $table_blockid 9]
    set table_blockid [dl_replaceByIndex $table_blockid $new_novel_block_vals 6]
    
    for {set i 0} { $i < $table_blockid_length } {incr i} {

	set table_blockid_val [dl_get $table_blockid $i]

	if {$table_blockid_val == 1} {

	    set habit_val [dl_get $time_vals $i]

	    dl_put $habit_block_vals $i $habit_val
	    
	} elseif {$table_blockid_val == 2} {

	    set numdev_val [dl_get $time_vals $i]

	    dl_put $numdev_block_vals $i $numdev_val
	    
	} elseif {$table_blockid_val == 5} {

	    set patdev_val [dl_get $time_vals $i]

	    dl_put $patdev_block_vals $i $patdev_val

	} elseif {$table_blockid_val == 6} {

	    set novel_val [dl_get $time_vals $i]

	    dl_put $novel_block_vals $i $novel_val
	    
	}; #end of if else statement
    }; #end of for loop
    

 # Need to remove 9's from lists to have values isolated in blocks
    set habit_block_vals [dl_select $habit_block_vals [dl_findAll [dl_noteq $habit_block_vals 9] 1]]
    set numdev_block_vals [dl_select $numdev_block_vals [dl_findAll [dl_noteq $numdev_block_vals 9] 1]]
    set patdev_block_vals [dl_select $patdev_block_vals [dl_findAll [dl_noteq $patdev_block_vals 9] 1]]
    set novel_block_vals [dl_select $novel_block_vals [dl_findAll [dl_noteq $novel_block_vals 9] 1]]

    #dl_set stimdg:habit_block_vals $habit_block_vals
    set habit_block [dl_uniqueNoSort $habit_block_vals]
    set numdev_block [dl_uniqueNoSort $numdev_block_vals]
    set patdev_block [dl_uniqueNoSort $patdev_block_vals]
    set novel_block [dl_uniqueNoSort $novel_block_vals]

    #### Loop that picks the images so that they don't repeat
    
    set uq_block_id [dl_unique stimdg:block_id]
    
    for {set i 0} {$i < [dl_llength $uq_block_id]} {incr i} {
        
        set block_id_idx [dl_get $uq_block_id $i]
        
	if {$block_id_idx == 1} {
	    set nstim 120
	    set stim_used [dl_zeros $nstim]
	    set poss_stim [dl_repeat "1 2 3 4" 30]
	    set stim_array [dl_repeat 9 $nstim]
	    
        } elseif {$block_id_idx == 2} {
	    set nstim 120
	    set stim_used [dl_zeros $nstim]
	    set poss_stim [dl_concat [dl_repeat "1 2 3 4" 24] [dl_repeat "5 6 7" 8]]
	    set stim_array [dl_repeat 9 $nstim]

	} elseif {$block_id_idx == 3} {
	    
	    set nstim 120
	    set stim_used [dl_zeros $nstim]
	    set poss_stim [dl_concat [dl_repeat "1 2 3 4" 24] [dl_repeat "5 6 7" 8]]
	    set stim_array [dl_repeat 9 $nstim]
	    
	} else {
	    set nstim 120
	    set stim_used [dl_zeros $nstim]
	    set poss_stim [dl_repeat "8 10 11 12" 30] 
	    set stim_array [dl_repeat 9 $nstim]
	}
    #Find the next position to fill in
    
        set stim_idx [dl_findAll $stim_array "9"]

    #Go through each idx line individually  
        foreach stimline [dl_tcllist $stim_idx] {
        #First line can be any habituation item
	    if {$stimline == 0} {
            #First stim. Find habit indices
	    #####
	    set habitindices [dl_oneof $poss_stim "1 2 3 4 8 10 11 12"]
	    set habit_match [dl_not [dl_and $habitindices [dl_not $stim_used] ] ]
	    #####
            #Find available stimuli
            set avail_stimidxs [dl_findAll $habit_match 0]
	    #set avail_stimidxs [dl_findAll $stim_used 0]
            #Choose randomly one of the available stimuli can use dl_pickone
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            
            dl_put $stim_array $stimline $actual_stim
            #This next put will mark the item in the zeros as used
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
	    #First part logic is sound. Always gives you a new num and marks it where it should be.
	} elseif {[dl_get [dl_oneof $stimline [dl_fromto 1 24] ] 0] == 1} {
	    #Make sure first 6 items are not deviant items
	    set laststim [dl_get $stim_array $lastLine]
	    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]]\
						[dl_not [dl_oneof $poss_stim\
							     "5 6 7"]]] "1"]
	    
	    set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
	    
        } else {
            #Find the available stimuli that are not the previous stimuli
            set laststim [dl_get $stim_array $lastLine]
	    
	    #If it's stims 1 2 3 4 then it's fine to choose any
	    if {[dl_get [dl_oneof $laststim "1 2 3 4"] 0] == 1} {
		set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
						    [dl_noteq $poss_stim $laststim]] "1"]
	    #If it's stims 8 10 11 12 then it's fine to choose any that isn't same as prev
	    } elseif {[dl_get [dl_oneof $laststim "8 10 11 12"] 0] == 1} {
		set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
						    [dl_noteq $poss_stim $laststim]] "1"]
		#If it's stims 5 6 7 then make sure they aren't consecutive	
	    } elseif {[dl_get [dl_oneof $laststim "5 6 7"] 0] == 1} {
		set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
							    [dl_noteq $poss_stim $laststim]]\
						    [dl_not [dl_oneof $poss_stim "5 6 7"]]] "1"]
	    }
		
	    

            if {[dl_llength $avail_stimidxs] == 0} {
        #Set list to 0 and pick first stim again
            set stim_used [dl_zeros $nstim]
            set avail_stimidxs [dl_findAll $stim_used 0]
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            dl_put $stim_array $stimline $actual_stim
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
                } else {
                if {[dl_llength $avail_stimidxs] > 1} {
                set chosen_idx [dl_pickone $avail_stimidxs]
                } else {
                set chosen_idx $avail_stimidxs
                }
            }
            
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
        }; #End of if else
        
        }; #End of Foreach
        
        if {$block_id_idx == 1} {
	    set habit_block [dl_append $stim_array 0]
        } elseif {$block_id_idx == 2} {
	    set numdev_block [dl_append $stim_array 0]
	} elseif {$block_id_idx == 3} {
	    set patdev_block [dl_append $stim_array 0]
	} elseif {$block_id_idx == 4} {
	    set novel_block [dl_append $stim_array 0]
	}

    }; #End of for loop
    #dl_set stimdg:novel_block_vals $novel_block_vals
    #Combine lists so now appear on right order in stimdg
    #First put together original lists with the new ids
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id] 
    dl_set stimdg:stim_types [dl_ilist]
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $habit_block]
	} elseif { $idtestvals == 2 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $numdev_block]
	} elseif { $idtestvals == 3 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $patdev_block]
	} elseif { $idtestvals == 4 } {
	    dl_set stimdg:stim_types [dl_combine stimdg:stim_types $novel_block]
	}; #end of if else#
    }; #end of foreach
    
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id] 
    dl_set stimdg:on_type [dl_ilist]
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type [dl_append $habit_block_vals 0]]
	} elseif { $idtestvals == 2 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type [dl_append $numdev_block_vals 0]]
	} elseif { $idtestvals == 3 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type [dl_append $patdev_block_vals 0]]
	} elseif { $idtestvals == 4 } {
	    dl_set stimdg:on_type [dl_combine stimdg:on_type [dl_append $novel_block_vals 0]]
	}; #end of if else
    }; #end of foreach

    #Now assign the images to be displayed 

    # Now assign the images depending on the assigned scram_objid

    set tasktrials [dl_llength stimdg:stim_types]
    dl_set stimdg:stimcountlist [dl_repeat "9" [dl_llength stimdg:stim_types]]
    dl_set stimdg:stimuli [dl_repeat [dl_slist null] $tasktrials]
 
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]

	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
	    
	    if {$stimIdx == 1} {
		dl_put stimdg:stimuli $i $img1
	    } elseif {$stimIdx == 2} {
		dl_put stimdg:stimuli $i $img2
	    } elseif {$stimIdx == 3} {
		dl_put stimdg:stimuli $i $img3
	    } elseif {$stimIdx == 4} {
		dl_put stimdg:stimuli $i $img4
	    } elseif {$stimIdx == 5} {
		dl_put stimdg:stimuli $i $img5          
	    } elseif {$stimIdx == 6} {
		dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 7} {
		dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 8} {
		dl_put stimdg:stimuli $i $img8
	    } elseif {$stimIdx == 10} {
		dl_put stimdg:stimuli $i $img9
	    } elseif {$stimIdx == 11} {
		dl_put stimdg:stimuli $i $img10
	    } elseif {$stimIdx == 12} {
		dl_put stimdg:stimuli $i $img11
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
        
	}; #End of for loop assigning imgs

    
	# Figure out how long each frame is based on refresh rate
	# FrameDuration ;# gives answer in *ms*
	set screenHz [screen_set RefreshRate] ;# frames/sec
	# For debugging in tcl
	#set screenHz 60
    # Reward
    # ------
    # Grab rewardDuration from the (quick)params
    # set reward_amount 250
    # dl_set stimdg:rewardDuration [dl_repeat $reward_amount $ntrials]

    set ntrials [dl_llength stimdg:block_id]
    dl_set stimdg:rwdInt_max [dl_repeat $rwdInt_max $ntrials]
    dl_set stimdg:rwdInt_min [dl_repeat $rwdInt_min $ntrials]
    dl_set stimdg:rwdInt_inc [dl_repeat $rwdInt_inc $ntrials]
    dl_set stimdg:rwdInt_n [dl_repeat $rwdInt_n $ntrials]

    # Want the fixation spot present for all the trials
    dl_set stimdg:fixPresent [dl_repeat $fixPresent $ntrials]
    dl_set stimdg:background_luminance [dl_repeat $bgLuminance $ntrials]

    #Bring the ITIs in from the table for assignment
    
    set some_itis $time_file:iti
    set isp $time_file:isp
    #Put together iti and ISP column
    #First, find idxs of isps
    set isp_idx [dl_findAll [dl_not $isp] 0]
    #Using these idxs match vals in the iti list to replace 0 vals for isps
    #Get list of values using idxs
    set isp_vals [dl_choose $isp $isp_idx]
    #Use isp vals and isp_idxs to replace in iti list
    set itis [dl_replaceByIndex $some_itis $isp_idx $isp_vals]
    
    set itis_length [dl_length $itis]
    #Set vars for each block that will contain each iti depending on id and deviant type
    
    set habit_block_itis [dl_float [dl_repeat 9 $itis_length] ]
    set numdev_block_itis [dl_float [dl_repeat 9 $itis_length] ]
    set patdev_block_itis [dl_float [dl_repeat 9 $itis_length] ]
    set novel_block_itis [dl_float [dl_repeat 9 $itis_length] ]
   
    #Loop through block id's and get iti vals

    for {set i 0} { $i < $itis_length } {incr i} {

	set table_blockid_val [dl_get $table_blockid $i]

	if {$table_blockid_val == 1} {

	    set habit_iti [dl_get $itis $i]

	    dl_put $habit_block_itis $i $habit_iti
	    
	} elseif {$table_blockid_val == 2} {

	    set numdev_iti [dl_get $itis $i]

	    dl_put $numdev_block_itis $i $numdev_iti
	    
	} elseif {$table_blockid_val == 5} {

	    set patdev_iti [dl_get $itis $i]

	    dl_put $patdev_block_itis $i $patdev_iti

	} elseif {$table_blockid_val == 6} {

	    set novel_iti [dl_get $itis $i]

	    dl_put $novel_block_itis $i $novel_iti
	    
	}; #end of if else statement
    }; #end of for loop

    #Now that have vals put them in the right order (these will be the off_times)
    #Remove 9's first and append 0 (fix time) at end of each list.

    set habit_itis [dl_append [dl_select $habit_block_itis [dl_findAll [dl_noteq $habit_block_itis 9] 1] ] 0]
    set numdev_itis [dl_append [dl_select $numdev_block_itis [dl_findAll [dl_noteq $numdev_block_itis 9] 1] ] 0]
    #set newexp_itis [dl_append [dl_select $newexp_block_itis [dl_findAll [dl_noteq $newexp_block_itis 9] 1] ] 0]
    set novel_itis [dl_append [dl_select $novel_block_itis [dl_findAll [dl_noteq $novel_block_itis 9] 1] ] 0]
    set patdev_itis [dl_append [dl_select $patdev_block_itis [dl_findAll [dl_noteq $patdev_block_itis 9] 1] ] 0]

    # Put the list together using current shuffled order
    set uq_stimtestids [dl_uniqueNoSort stimdg:block_id]
    set off_Sec [dl_flist]
    
    for {set i 0} {$i < [dl_llength $uq_stimtestids]} {incr i} {
	set idtestvals [dl_get $uq_stimtestids $i]
	if { $idtestvals == 1 } {
	    set off_Sec [dl_combine $off_Sec $habit_itis]
	} elseif { $idtestvals == 2 } {
	    set off_Sec [dl_combine $off_Sec $numdev_itis]
	} elseif { $idtestvals == 3 } {
	    set off_Sec [dl_combine $off_Sec $patdev_itis]
	} elseif { $idtestvals == 4 } {
	    set off_Sec [dl_combine $off_Sec $novel_itis]
	}; #end of if else#
    }; #end of foreach

            ###Combine lists to get stim_types on stimdg

    
    # Set the Ontimes only since offtimes are already set


    #set restofoffsec [dl_repeat 0.1 [expr $ntrials - [dl_llength $on_Sec]]]
    set stimOffDur $off_Sec
    set stimOnDur 0.2
    # Figure out how long each frame is based on refresh rate
    # FrameDuration ;# gives answer in *ms*
   set screenHz [screen_set RefreshRate] ;# frames/sec
    # For debugging in tcl
    #set screenHz 60
    
    #### 
    dl_set stimdg:onSec [dl_repeat 0.1 $ntrials]
    dl_set stimdg:offSec [dl_repeat 0.1 $ntrials]
    # Initialize the columns for frame numbers (always integers)
    dl_set stimdg:onFrameN [dl_repeat 0 $ntrials]
   dl_set stimdg:offFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:endFrameN [dl_repeat 0 $ntrials]
    
	for { set i 0 } { $i < $ntrials } { incr i } {
	    # Have a choice, can either caluculate the times and attempt
	    #  to get the frames right, or can calculate the frames, and 
	    #  calculate the times accordingly.
	    # This is frame-based

	    #onSec
	    #-----
	    if {$i == 0} {
		# First trial
		#dl_put stimdg:onSec $i 0
		dl_put stimdg:onFrameN $i 0
	    } else {
		# previous block type
		set prev_block_type [lindex [dl_tcllist stimdg:block_type] \
					 [expr $i - 1]]
		
		# Set the frames, by prev block type
		if { $prev_block_type == "fixation" } {
		    set prevOffFrames 0

		} else {
		    # round because frames must be integers
		    set prevOffFrames [expr round([dl_get $stimOffDur $i] * $screenHz)]
		}

		#onFrameN = previous trial offFrame + 
		#           prevOffFrames (duration in frames)
		dl_put stimdg:onFrameN $i \
		    [expr [lindex [dl_tcllist stimdg:offFrameN] [expr $i - 1]] \
			 + $prevOffFrames]

		# Also set the previous end frame. 
		#  Repeats info, but keeps the iti explicit
		dl_put stimdg:endFrameN [expr $i - 1] \
		    [dl_get stimdg:onFrameN $i]
	    }
	    # Calculate the corresponding on time in seconds
	    dl_put stimdg:onSec $i \
		[expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
		     / ($screenHz + 0.0)] ;#intro floating point

	    #offSec
	    #------
	    # Get the current block type, fixation or otherwise
	    set block_type [lindex [dl_tcllist stimdg:block_type] $i] 

	    # Set the frames, by block type (note != not equal)
	    #  round because frames must be integers
	    if { $block_type == "fixation" } {
		set currOnFrames [expr round($fixBlockDur * $screenHz)]
	
	    } else {
		# Not fixation
		set currOnFrames [expr round($stimOnDur * $screenHz)]
	    }
	    
	    # offFrameN = onFrameN + currOnFrames (dur in frames)
	    dl_put stimdg:offFrameN $i \
		[expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
		     + $currOnFrames]
	
	    # Calculate the corresponding off time in seconds
	    dl_put stimdg:offSec $i \
		[expr [lindex [dl_tcllist stimdg:offFrameN] $i] \
		     / ($screenHz + 0.0)] ;#intro floating point
	    
	    set lasttrial [dl_last $ntrials]

	    ### Fixed so that last frame and endframe match
	    
	    if {$i == [expr $lasttrial-1] } {
		dl_put stimdg:endFrameN $i [dl_last stimdg:offFrameN]
	    }
			   
	} ;#end trial loop
    dl_set stimdg:offsec $off_Sec

    if { [dl_sum [dl_find [dl_eq stimdg:stimcountlist 2] 1]] >= 1 } { error "fatal seq repeat, pick again" }
    
}; #End proc time_only

proc image_only  { monkey session block_order \
			  rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
    ####Starting from Jitter_loc####
    ####Right now just copied jitter loc protocol.
    ####Have to change block strcuct and image selection.
    
    # Variables (some of these may want as inputs)

    set numBlocksEachCond 1
    set imgPerBlock 120
    set stimOnDur 0.2
    #set stimOffDur 0.2
    set fixBlockDur 14
    set fixPresent 1 ;# fixation spot for everything
    set bgLuminance 255

    # Tarr just loads all the images and then shuffles them and uses them
    # in shuffled order
    # 0=Faces, 1=Objects, 2=Scenes, 3=Scrambled Objects 4=Bodyparts
    # 5=Fixation 

    # Set the directories in the desired order and get the names
    # Last item is not a folder but a place holder for the fix block
    if [file exists c:/stimuli/MRILocalizers] {
	set mripath c:/stimuli/MRILocalizers
    } else {
	set mripath ../stimuli/MRILocalizers
    }

    dl_local imgFolders [eval dl_slist $mripath/faces \
			     $mripath/objects \
			     $mripath/scenes \
			     $mripath/scramobjects \
			     $mripath/bodyparts \
			     fixation]
    
    # This has to be a tcllist for the way it is used in create_blocks
    # It also must include fixation if there is fixation used as a block
    # dl_local img_groups [dl_filebase $imgFolders]
    # This line doesn't work:
    # Need to add fixation and figure the right way of getting out of dl
    set img_groups [dl_tcllist [dl_filebase $imgFolders]]
    set fixblocknum [lsearch $img_groups "fixation"]

    # Figure out the total number of stim/images that will need of each kind
    set nTotImg [expr $numBlocksEachCond * $imgPerBlock]


    # stimdg
    # ------
    if {[dg_exists stimdg]} {
	dg_delete stimdg
    }
    # Note that stimdg is a global, so no $ in referencing it
    dg_create stimdg

    dl_set stimdg:version [dl_slist [namespace current]]
    
    # Procedure that converts the list of block orders into columns that can
    # be used in stimdg. returns a dg

    dl_local block_n [dl_ilist 0 1 2 3 4 5]
    dl_local repeat_n [dl_ilist 120 1 120 1 120 1]
    
    dl_set stimdg:block_n [dl_repeat $block_n $repeat_n]
    
    dl_set stimdg:block_id [ dl_concat [dl_concat [dl_append [dl_repeat 1 $imgPerBlock] 0]\
				[dl_append [dl_repeat 2 $imgPerBlock] 0] ]\
				 [dl_append [dl_repeat 3 $imgPerBlock] 0] ]
    
    # Once have the basics of stimdg, want the on and off time of every line
    set ntrials [dl_llength stimdg:block_id]

    dl_set stimdg:block_type [dl_repeat [dl_slist null] [dl_llength stimdg:block_id]]
    for {set i 0} {$i < [dl_llength stimdg:block_id]} {incr i} {
	set stimid [lindex [dl_tcllist stimdg:block_id] $i]
	if {$stimid == 1} {
	    #Set to be a block with habituation images
	    dl_put stimdg:block_type $i "Habituation"
	} elseif {$stimid == 2} {
	    dl_put stimdg:block_type $i "Deviant"
	} elseif {$stimid == 3} {
	    dl_put stimdg:block_type $i "Novel"
	} elseif {$stimid == 0} {
	    dl_put stimdg:block_type $i "fixation"
	}; #End of if else
    }; #End of for loop
    
    #Call images to place and use later. 
   set filefolder ../stimuli/MRILocalizers/fractals/
    set ext .png ;#name of extension of image
    #set filename $basefile${filenum}${ext}; #example to combine pieces
    set filename "_fractal_"
    
    for {set i 1} {$i < 12} {incr i} {
	set img$i $filefolder${session}${filename}${i}${ext}
    }

    # Create list of non-repeating stim_ids to assign images later.
    # Do something similar to passive seq selection.
    # Cycle through set id lists, check off selected values to make sure they don't repeat.

    set uq_block_id [dl_unique stimdg:block_id]
    
    for {set i 0} {$i < [dl_llength $uq_block_id]} {incr i} {
        
        set block_id_idx [dl_get $uq_block_id $i]
        
	if {$block_id_idx == 1} {
	    set nstim 120
	    set stim_used [dl_zeros $nstim]
	    set poss_stim [dl_repeat "1 2 3 4" 30]
	    set stim_array [dl_repeat 9 $nstim]
	    
        } elseif {$block_id_idx == 2} {
	    set nstim 120
	    set stim_used [dl_zeros $nstim]
	    set poss_stim [dl_concat [dl_repeat "1 2 3 4" 24] [dl_repeat "5 6 7" 8]]
	    set stim_array [dl_repeat 9 $nstim]
	    
	} else {
	    set nstim 120
	    set stim_used [dl_zeros $nstim]
	    set poss_stim [dl_repeat "8 10 11 12" 30] 
	    set stim_array [dl_repeat 9 $nstim]
	}
    #Find the next position to fill in
    
        set stim_idx [dl_findAll $stim_array "9"]

    #Go through each idx line individually  
        foreach stimline [dl_tcllist $stim_idx] {
        #First line can be any habituation item
	    if {$stimline == 0} {
            #First stim. Find habit indices
	    #####
	    set habitindices [dl_oneof $poss_stim "1 2 3 4 8 10 11 12"]
	    set habit_match [dl_not [dl_and $habitindices [dl_not $stim_used] ] ]
	    #####
            #Find available stimuli
            set avail_stimidxs [dl_findAll $habit_match 0]
	    #set avail_stimidxs [dl_findAll $stim_used 0]
            #Choose randomly one of the available stimuli can use dl_pickone
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            
            dl_put $stim_array $stimline $actual_stim
            #This next put will mark the item in the zeros as used
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
	    #First part logic is sound. Always gives you a new num and marks it where it should be.
	} elseif {[dl_get [dl_oneof $stimline [dl_fromto 1 24] ] 0] == 1} {
	    #Make sure first 6 items are not deviant items
	    set laststim [dl_get $stim_array $lastLine]
	    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]]\
						[dl_not [dl_oneof $poss_stim\
							     "5 6 7"]]] "1"]
	    
	    set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
	    
        } else {
            #Find the available stimuli that are not the previous stimuli
            set laststim [dl_get $stim_array $lastLine]
	    
	    #If it's stims 1 2 3 4 then it's fine to choose any
	    if {[dl_get [dl_oneof $laststim "1 2 3 4"] 0] == 1} {
		set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
						    [dl_noteq $poss_stim $laststim]] "1"]
	    #If it's stims 8 10 11 12 then it's fine to choose any that isn't same as prev
	    } elseif {[dl_get [dl_oneof $laststim "8 10 11 12"] 0] == 1} {
		set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
						    [dl_noteq $poss_stim $laststim]] "1"]
		#If it's stims 5 6 7 then make sure they aren't consecutive	
	    } elseif {[dl_get [dl_oneof $laststim "5 6 7"] 0] == 1} {
		set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
							    [dl_noteq $poss_stim $laststim]]\
						    [dl_not [dl_oneof $poss_stim "5 6 7"]]] "1"]
	    }
		
	    

            if {[dl_llength $avail_stimidxs] == 0} {
        #Set list to 0 and pick first stim again
            set stim_used [dl_zeros $nstim]
            set avail_stimidxs [dl_findAll $stim_used 0]
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            dl_put $stim_array $stimline $actual_stim
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
                } else {
                if {[dl_llength $avail_stimidxs] > 1} {
                set chosen_idx [dl_pickone $avail_stimidxs]
                } else {
                set chosen_idx $avail_stimidxs
                }
            }
            
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
        }; #End of if else
        
        }; #End of Foreach
        
        if {$block_id_idx == 1} {
	    set habit_block [dl_append $stim_array 0]
        } elseif {$block_id_idx == 2} {
	    set deviant_block [dl_append $stim_array 0]
	} elseif {$block_id_idx == 3} {
	    set novel_block [dl_append $stim_array 0]
	}
    }; #End of for loop

    dl_set stimdg:scram_objids [dl_concat [dl_concat $habit_block $deviant_block] $novel_block]

    # Now assign the images depending on the assigned scram_objid

    set tasktrials [dl_llength stimdg:scram_objids]
    dl_set stimdg:stimcountlist [dl_repeat "9" [dl_llength stimdg:scram_objids]]
    dl_set stimdg:stimuli [dl_repeat [dl_slist null] $tasktrials]
 
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:scram_objids] $i]

	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
	    
	    if {$stimIdx == 1} {
		dl_put stimdg:stimuli $i $img1
	    } elseif {$stimIdx == 2} {
		dl_put stimdg:stimuli $i $img2
	    } elseif {$stimIdx == 3} {
		dl_put stimdg:stimuli $i $img3
	    } elseif {$stimIdx == 4} {
		dl_put stimdg:stimuli $i $img4
	    } elseif {$stimIdx == 5} {
		dl_put stimdg:stimuli $i $img5          
	    } elseif {$stimIdx == 6} {
		dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 7} {
		dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 8} {
		dl_put stimdg:stimuli $i $img8
	    } elseif {$stimIdx == 10} {
		dl_put stimdg:stimuli $i $img9
	    } elseif {$stimIdx == 11} {
		dl_put stimdg:stimuli $i $img10
	    } elseif {$stimIdx == 12} {
		dl_put stimdg:stimuli $i $img11
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }

	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:scram_objids]-1]} {
        
		if {[dl_get stimdg:scram_objids $i] != [dl_get stimdg:scram_objids [expr $i+1]]} {
		    set imgcount 1
		}
	    }
        
	}; #End of for loop assigning imgs
    
	# Figure out how long each frame is based on refresh rate
	# FrameDuration ;# gives answer in *ms*
	set screenHz [screen_set RefreshRate] ;# frames/sec
	# For debugging in tcl
	#set screenHz 60

	
	# Reward
	# ------
	# Grab rewardDuration from the (quick)params
	# set reward_amount 250
	# dl_set stimdg:rewardDuration [dl_repeat $reward_amount $ntrials]

	dl_set stimdg:rwdInt_max [dl_repeat $rwdInt_max $ntrials]
	dl_set stimdg:rwdInt_min [dl_repeat $rwdInt_min $ntrials]
	dl_set stimdg:rwdInt_inc [dl_repeat $rwdInt_inc $ntrials]
	dl_set stimdg:rwdInt_n [dl_repeat $rwdInt_n $ntrials]

	# Want the fixation spot present for all the trials
	dl_set stimdg:fixPresent [dl_repeat $fixPresent $ntrials]
	dl_set stimdg:background_luminance [dl_repeat $bgLuminance $ntrials]

	# Times (obj_loc)
	# -----

	# Loop through all the "trials"
	# Assign start and stop times, in seconds, for each line
	# Initialize the colums for times
	#   Initialize to a decimal otherwise get an error when try to assign
	dl_set stimdg:onSec [dl_repeat 0.1 $ntrials]
	dl_set stimdg:offSec [dl_repeat 0.1 $ntrials]
	# Initialize the columns for frame numbers (always integers)
	dl_set stimdg:onFrameN [dl_repeat 0 $ntrials]
	dl_set stimdg:offFrameN [dl_repeat 0 $ntrials]
	dl_set stimdg:endFrameN [dl_repeat 0 $ntrials]

	###### Setting stimOffDur to ITI list of vals
	# First need to read ITI list. Right now this is saved in 
	# L:\projects\stimulator2\mri\N_localizers\timing_info
	# load table with dgz vals
	
    package require dlsh
    set obj_itis [dg_read mri/Scan_seq/image_only_itis/image_only_itis.dgz]

	#Want to pick random column timing each time

    set col [dl_pickone [dl_fromto 0 20] ]
    set iti_vals $obj_itis:$col
    set stimOffDur $iti_vals

    	
	for { set i 0 } { $i < $ntrials } { incr i } {
	    # Have a choice, can either caluculate the times and attempt
	    #  to get the frames right, or can calculate the frames, and 
	    #  calculate the times accordingly.
	    # This is frame-based

	    #onSec
	    #-----
	    if {$i == 0} {
		# First trial
		#dl_put stimdg:onSec $i 0
		dl_put stimdg:onFrameN $i 0
	    } else {
		# previous block type
		set prev_block_type [lindex [dl_tcllist stimdg:block_type] \
					 [expr $i - 1]]
		
		# Set the frames, by prev block type
		if { $prev_block_type == "fixation" } {
		    set prevOffFrames 0

		} else {
		    # round because frames must be integers
		    set prevOffFrames [expr round([dl_get $stimOffDur $i] * $screenHz)]
		}

		#onFrameN = previous trial offFrame + 
		#           prevOffFrames (duration in frames)
		dl_put stimdg:onFrameN $i \
		    [expr [lindex [dl_tcllist stimdg:offFrameN] [expr $i - 1]] \
			 + $prevOffFrames]

		# Also set the previous end frame. 
		#  Repeats info, but keeps the iti explicit
		dl_put stimdg:endFrameN [expr $i - 1] \
		    [dl_get stimdg:onFrameN $i]
	    }
	    # Calculate the corresponding on time in seconds
	    dl_put stimdg:onSec $i \
		[expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
		     / ($screenHz + 0.0)] ;#intro floating point

	    #offSec
	    #------
	    # Get the current block type, fixation or otherwise
	    set block_type [lindex [dl_tcllist stimdg:block_type] $i] 

	    # Set the frames, by block type (note != not equal)
	    #  round because frames must be integers
	    if { $block_type == "fixation" } {
		set currOnFrames [expr round($fixBlockDur * $screenHz)]
	
	    } else {
		# Not fixation
		set currOnFrames [expr round($stimOnDur * $screenHz)]
	    }
	    
	    # offFrameN = onFrameN + currOnFrames (dur in frames)
	    dl_put stimdg:offFrameN $i \
		[expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
		     + $currOnFrames]
	
	    # Calculate the corresponding off time in seconds
	    dl_put stimdg:offSec $i \
		[expr [lindex [dl_tcllist stimdg:offFrameN] $i] \
		     / ($screenHz + 0.0)] ;#intro floating point
	    
	    set lasttrial [dl_last $ntrials]

	    ### Fixed so that last frame and endframe match
	    
	    if {$i == [expr $lasttrial-1] } {
		dl_put stimdg:endFrameN $i [dl_last stimdg:offFrameN]
	    }
			   
	} ;#end trial loop
	dl_set stimdg:ITIs $stimOffDur
	# For debugging
	#return stimdg
    if { [dl_sum [dl_find [dl_eq stimdg:stimcountlist 2] 1]] >= 1 } { error "fatal seq repeat, pick again" }
} ;#end proc image_only

proc habit_only_doubled { monkey session block_order deviant_type\
			   rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
	set maxtries 100
	for { set tries 0 } { $tries < $maxtries } { incr tries } {
	    if { [catch { try_habit_only_doubled $monkey $session $block_order \
			      $deviant_type $rwdInt_max $rwdInt_min \
 			      $rwdInt_inc $rwdInt_n } ] == 0 } break
 	}
 	if { $tries == $maxtries } { error "unable to find sequence" }
     }
    
proc try_habit_only_doubled  { monkey session block_order deviant_type\
			   rwdInt_max rwdInt_min rwdInt_inc rwdInt_n } {
    set numBlocksEachCond 4
    set imgPerBlock 120
    set fixBlockDur 14
    set fixPresent 1 ;#fix spot present for everything
    set bgLuminance 255
    set fixation 0
    set stimOnDur 0.2
    #Set paths for images
    
    if [file exists c:/stimuli/MRILocalizers] {
        set mripath c:/stimuli/MRILocalizers
    } else {
        set mripath ../stimuli/MRILocalizers
    }

    dl_local imgFolders [eval dl_slist $mripath/scramobjects \
			     fixation]
    
    #Basics: Making sure stimdg exists and some defaults
    # Need to add fixation and figure the right way of getting out of dl
    set img_groups [dl_tcllist [dl_filebase $imgFolders]]
    set fixblocknum [lsearch $img_groups "fixation"]

          # Figure out the total number of stim/images that will need of each kind
    set nTotImg [expr $numBlocksEachCond * $imgPerBlock]
            
    # Ok, so let's try to make stimdg exist
    # stimdg
    # ------
    if {[dg_exists stimdg]} {
        dg_delete stimdg
    }

    dg_create stimdg

    dl_set stimdg:version [dl_slist [namespace current]]
 
    dl_set stimdg:block_n [dl_ilist]
    dl_set stimdg:block_id [dl_ilist]
    

    # For this version of the task the 2 deviant blocks will be shuffled
    # (just order of appearance of block, not internally)
    #First make a simple that has the id's you want. Here habit will be 1, short and long dev 2
    #medium dev 3, novel block 4
    dl_local habit [dl_ilist 1]
    dl_local habit_2 [dl_ilist 2]
    set block_type [dl_combine [dl_concat [dl_combine $fixation $habit] $fixation]\
			$habit_2 $fixation]

    ###Makes the actual total list with the correct number of ids
    for {set i 0} {$i < [dl_llength $block_type]} {incr i} {
	set blocktypeid [dl_get $block_type $i]
	#Cycle through block type ids and expand non zero values according to total amt of images
	#(set on imgPerBlock)
	
	if {$blocktypeid != 0} {
	    dl_set stimdg:block_id [dl_combine stimdg:block_id [dl_repeat $blocktypeid $imgPerBlock]]
	} elseif {$blocktypeid == 0} {
	    dl_set stimdg:block_id [dl_append stimdg:block_id $blocktypeid]
	}
    }
    
    # Create column for block number (block_n)
    #set nblocks [expr $numBlocksEachCond*2]
    dl_set stimdg:block_n [dl_repeat "0 1 2 3 4" "1 $imgPerBlock 1 $imgPerBlock 1"]

    ###Place actual names of each stimtype next to its id
    
    dl_set stimdg:block_type [dl_repeat [dl_slist null] [dl_llength stimdg:block_id]]

    for {set i 0} {$i < [dl_llength stimdg:block_id]} {incr i} {
	set stimid [lindex [dl_tcllist stimdg:block_id] $i]
	if {$stimid == 0} {
	    dl_put stimdg:block_type $i "fixation"
	} elseif {$stimid == 1} {
	    if {$block_order == 0} {
		dl_put stimdg:block_type $i "AAAA"
	    } elseif {$block_order == 1} {
		dl_put stimdg:block_type $i "AAAB"
	    }
        } elseif {$stimid == 2} {
	    if {$deviant_type == "number"} {
		#We actually want the second block to be a different type/
		#some deviant each time. Want to add an option for that
		dl_put stimdg:block_type $i "number"
	    } elseif {$deviant_type == "pattern"} {
		dl_put stimdg:block_type $i "pattern"
	    }  elseif {$deviant_type == "both"} {
		dl_put stimdg:block_type $i "both"
	    }  elseif {$deviant_type == "control"} {
		dl_put stimdg:block_type $i "control"
	    }; #End of if else
	}; #End if else for assigning block names
    }; #end of for loop

    ###Continuing here NYR 9/20/2018
    ###Now bring up images. For now still using the same 4 that have been using for habituation. This will change when we decide on fractals or blobs

        #call images to place and use later
    set filefolder ../stimuli/MRILocalizers/fractals/
    set ext .png ;#name of extension of image
    #set filename $basefile${filenum}${ext}; #example to combine pieces
    set filename "_fractal_"
    
    for {set i 1} {$i < 8} {incr i} {
	set img$i $filefolder${session}${filename}${i}${ext}
    }
    

    #9/24/2018
    #Image order will be chosen the way it is chosen on pseq code.
    #Except now only have to happen for 1 block. Additionally, only choosing id for identity of stimuli since now there is no specific timing for sequences, only ITI's generated by DB.
    
    set uq_block_id [dl_unique stimdg:block_id]
    
    for {set i 0} {$i < [dl_llength $uq_block_id]} {incr i} {
        
        set block_id_idx [dl_get $uq_block_id $i]
        
	if {$block_id_idx == 1} {
	    if {$block_order == 0} {
		set nstim 28
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_repeat "1 2 3 4" 7]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_select "1 2 3 4 21 22 23 24 25 26 27 28" [dl_randchoose 12 6]]]
		set stim_array [dl_repeat 9 $nstim]
	    }
        } elseif {$deviant_type == "number"} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 5 6 7 35 36 37]]
		set stim_array [dl_repeat 9 $nstim]
	    }
	} elseif {$deviant_type == "control"} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_repeat "5 6 7" 2]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 29 30 31 32 33 34]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	} elseif {$deviant_type == "both"} {
	    if {$block_order == 0} {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 8 10 11 18 19 20]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	    
	} elseif {$deviant_type == "pattern"} {
	    if {$block_order == 0} {
	    set nstim 30
            set stim_used [dl_zeros $nstim]
            set poss_stim [dl_concat [dl_repeat "1 2 3 4" 6] [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $nstim]
	    } else {
		set nstim 30
		set stim_used [dl_zeros $nstim]
		set poss_stim [dl_concat [dl_repeat "1 2 3 4 21 22 23 24 25 26 27 28" 2]\
				   [dl_ilist 12 13 14 15 16 17]]
		set stim_array [dl_repeat 9 $nstim]		
	    }
	}
    #Find the next position to fill in
    
        set stim_idx [dl_findAll $stim_array "9"]

    #Go through each idx line individually  
        foreach stimline [dl_tcllist $stim_idx] {
        #First line can be any habituation item
	    if {$stimline == 0} {
            #First stim. Find habit indices
	    #####
	    set habitindices [dl_oneof $poss_stim "1 2 3 4 21 22 23 24 25 26 27 28"]
	    set habit_match [dl_not [dl_and $habitindices [dl_not $stim_used] ] ]
	    #####
            #Find available stimuli
            set avail_stimidxs [dl_findAll $habit_match 0]
	    #set avail_stimidxs [dl_findAll $stim_used 0]
            #Choose randomly one of the available stimuli can use dl_pickone
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            
            dl_put $stim_array $stimline $actual_stim
            #This next put will mark the item in the zeros as used
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
	    #First part logic is sound. Always gives you a new num and marks it where it should be.
	} elseif {[dl_get [dl_oneof $stimline "1 2 3 4 5"] 0] == 1} {
	    set laststim [dl_get $stim_array $lastLine]
	    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]]\
						[dl_not [dl_oneof $poss_stim\
							     "5 6 7 35 36 37 29 30 31 32 33 34\
							     8 10 11 18 19 20 12 13 14 15 16 17"]]] "1"]
	    
	    set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
	    
        } else {
            #Find the available stimuli that are not the previous stimuli
            set laststim [dl_get $stim_array $lastLine]
	    
	    if {$block_order == 0} {
		#If it's stims 1 2 3 4 then it's fine to choose any
		if {[dl_get [dl_oneof $laststim "1 2 3 4"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]] "1"]
		    
		} elseif {[dl_get [dl_oneof $laststim "8 10 11 18 19 20"] 0] == 1} {
		    #Choose so devs don't follow each other (for all other conds)
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "8 10 11 18 19 20"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "5 6 7"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "5 6 7"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "12 13 14 15 16 17"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "12 13 14 15 16 17"]]] "1"]
		}
		
	    } else {
		#Ask to check for last again cause otherwise doesn't find it
		set laststim [dl_get $stim_array $lastLine]
		#Make sure that the ones that start with 1 aren't chosen
		if {[dl_get [dl_oneof $laststim "4 23 26"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
						        [dl_not [dl_oneof $poss_stim "1 2 3"]]] "1"]
		    #Make sure that the ones that start with 2 aren't chosen
		} elseif {[dl_get [dl_oneof $laststim "1 24 27"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "4 21 22"]]] "1"]
		    #Make sure that the ones that start with 3 aren't chosen
		} elseif {[dl_get [dl_oneof $laststim "2 21 28"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "23 24 25"]]] "1"]
		    #Make sure that the ones that start with 4 aren't chosen		    
		} elseif {[dl_get [dl_oneof $laststim "3 22 25"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "26 27 28"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "8 10 11 18 19 20"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "8 10 11 18 19 20"]]] "1"]
		    ##Added these lines because was still getting deviants one after the other
		} elseif {[dl_get [dl_oneof $laststim "5 6 7 35 36 37"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "5 6 7 35 36 37"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "12 13 14 15 16 17"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "12 13 14 15 16 17"]]] "1"]
		} elseif {[dl_get [dl_oneof $laststim "29 30 31 32 33 34"] 0] == 1} {
		    set avail_stimidxs [dl_findAll [dl_and [dl_and [dl_eq $stim_used "0"] \
								[dl_noteq $poss_stim $laststim]]\
							[dl_not [dl_oneof $poss_stim "29 30 31 32 33 34"]]] "1"]		    
		} else {
		    set avail_stimidxs [dl_findAll [dl_and [dl_eq $stim_used "0"] \
							[dl_noteq $poss_stim $laststim]] "1"]
		}
	    }

            if {[dl_llength $avail_stimidxs] == 0} {
        #Set list to 0 and pick first stim again
            set stim_used [dl_zeros $nstim]
            set avail_stimidxs [dl_findAll $stim_used 0]
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
        
            dl_put $stim_array $stimline $actual_stim
            dl_put $stim_used $chosen_idx 1

            set lastLine $stimline
                } else {
                if {[dl_llength $avail_stimidxs] > 1} {
                set chosen_idx [dl_pickone $avail_stimidxs]
                } else {
                set chosen_idx $avail_stimidxs
                }
            }
            
            set chosen_idx [dl_pickone $avail_stimidxs]
            set actual_stim [dl_get $poss_stim $chosen_idx]
            
            dl_put $stim_array $stimline $actual_stim
            
            dl_put $stim_used $chosen_idx 1
            
            set lastLine $stimline
        }; #End of if else
        
        }; #End of Foreach
        
	if {$block_id_idx == 1} {
	    if {$block_order == 0} {
		set habit_block [dl_concat $stim_array \
				     [dl_select "1 2 3 4" [dl_randchoose 4 2]]]
	    } else {
		set habit_block $stim_array
	    }
	    } elseif {$block_id_idx == 2} {
		set second_block $stim_array
	    }
	
    }; #End of for loop
    
    
    #Now that have ids, expand lists and add fixation block id's (0) at beginning and end of list
    #Expand first. Same as for other versions of passive seq
    #Repeat values for either type by 4.
    #Substitution of 4th item in images for AAAB type will happen during stimulus assignment.
    
    #This is for AAAA habit type seq
    #Expanding just the control, pattern, and habituation sequences is pretty straightfoward
    #Just multiply everything x 4 for habituation block
    set exphabit [dl_prepend [dl_append [dl_repeat $habit_block 4] 0] 0]
    
    if {$deviant_type == "control" || $deviant_type == "pattern"} {
	#Now expand the second block
	set exphabit_2 [dl_append [dl_repeat $second_block 4] 0]
    
	dl_set stimdg:stim_types [dl_combine $exphabit $exphabit_2]
	
    } elseif {$deviant_type == "number" || $deviant_type == "both"} {
	#Now have to assign numbers for expanding deviants at random, from possible
	#Selection of 6 total values of either 0 or 1
	#Can't just shuffle and assign all of these, make sure they are balanced.
	set curr_dev [dl_zeros 6]
	set curr_rep [dl_zeros 6]
	#Go through stim_list, and assign values for expanding.
	#Can shuffle some for other conditions
	set shuff_vals [dl_shuffle [dl_ilist 2 2 2 6 6 6] ]
	#We can save and use this list later for image assignment as well.
	#Make empty list for repeating values
	set numberdev_rep [dl_repeat "9" [dl_llength $second_block]]
	#Loop through list and assign value for expanding, 4 if it's a habituation image
	#2 or 6 if it is any type of number deviant
	set rep_counter 0
	for {set i 0} {$i < [dl_llength $second_block]} {incr i} {
	    set dev_vals [lindex [dl_tcllist $second_block] $i]
	    if {[dl_get [dl_oneof $dev_vals "1 2 3 4 21 22 23 24 25 26 27 28"] 0] == 1} {
		dl_put $numberdev_rep $i 4
	    } elseif {[dl_get [dl_oneof $dev_vals "5 6 7 35 36 37 8 10 11 18 19 20"] 0] == 1} {
		#If it is the first, assign any
		if {$rep_counter == 0} {
		    dl_put $numberdev_rep $i [dl_pickone "2 6"]
		    #Afterwards, compare lists. If have some repetition, check what repetition value has been assigned
		} elseif {[dl_sum [dl_eq $curr_dev $dev_vals]] >= 1} {
		    #Check which value is repeated and the rep assigned
		    set repeated_val [dl_get $curr_rep \
					  [dl_find [dl_eq $curr_dev\
							$dev_vals] 1] ]
		    # Pick the one that was not used before
		    set unused_rep \
			[dl_not [dl_oneof "2 6" $repeated_val]]
		    
		    dl_put $numberdev_rep $i [dl_pickone\
						  [dl_select "2 6" $unused_rep]]
	         #Otherwise, if one of these combinations, choose one over the other
		} else {
		    if {[dl_sum [dl_eq $curr_dev [dl_ilist 8 5 19 35 11 36]]] >= 1 && [dl_sum [dl_eq $dev_vals [dl_ilist 7 10 20 37 18 6]]] >= 1} {
			#Check what the current value is
			set repeated_val [dl_get $curr_rep \
					  [dl_find [dl_eq $curr_dev\
							$dev_vals] 1] ]
		    # Pick the one that was not used before
		    set unused_rep \
			[dl_not [dl_oneof "2 6" $repeated_val]]
		    
		    dl_put $numberdev_rep $i [dl_pickone\
						  [dl_select "2 6" $unused_rep]]
		    } else {
		 	dl_put $numberdev_rep $i [dl_pickone "2 6"]
		    }
		    
		}
		#Save which value this is, and the rep assigned
		dl_put $curr_dev $rep_counter $dev_vals
		dl_put $curr_rep $rep_counter [dl_get $numberdev_rep $i]
		set rep_counter [expr $rep_counter+1]
	    }
	}
	
	set expdev [dl_append [dl_repeat $second_block $numberdev_rep] 0]
	dl_set stimdg:stim_types [dl_combine $exphabit $expdev]
	set reps [dl_combine $exphabit [dl_append [dl_repeat $numberdev_rep $numberdev_rep] 0]]
    }; #End else if for expanding deviants


    #Now assign images for stimuli
    
    set totalon_type stimdg:stim_types
    #So far so good...
      dl_set stimdg:stimcountlist [dl_repeat "9" [dl_llength stimdg:stim_types]]
    set tasktrials [dl_llength stimdg:stim_types]
    
    dl_set stimdg:stimuli [dl_repeat [dl_slist null] $tasktrials]
    
    if {$block_order == 0} {
	#Block order 0 is AAAA
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
        
	    if {$stimIdx == 1} {
		dl_put stimdg:stimuli $i $img1
	    } elseif {$stimIdx == 2} {
		dl_put stimdg:stimuli $i $img2
	    } elseif {$stimIdx == 3} {
		dl_put stimdg:stimuli $i $img3
	    } elseif {$stimIdx == 4} {
		dl_put stimdg:stimuli $i $img4
	    } elseif {$stimIdx == 5} {
		dl_put stimdg:stimuli $i $img5          
	    } elseif {$stimIdx == 6} {
		dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 7} {
		dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 8} {
		#5-6 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get $reps $i] == 6} {    
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 10} {
		#6-5 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 11} {
		#7-5 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
		#5-7 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 19} {
		#6-7 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 20} {
		#7-6 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get $reps $i] == 6} {		    
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 13} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 14} {
		if {$imgcount == 4} {        
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}            
	    } elseif {$stimIdx == 15} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 16} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}        
	    } elseif {$stimIdx == 17} {
		if {$imgcount == 4} {            
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}        
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
        
	}; #End of for loop assigning imgs
    } else {
	
	for {set i 0} { $i < $tasktrials } { incr i} {
	    set stimIdx [lindex [dl_tcllist stimdg:stim_types] $i]
	    if {$i == 0} {
		set imgcount 1
	    } 
	    dl_put stimdg:stimcountlist $i $imgcount
	    #Will have individual id for each habit combination
	    
	    if {$stimIdx == 1} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 2} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 3} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img1
		}
	    } elseif {$stimIdx == 4} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 11} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 21} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img2
		}          
	    } elseif {$stimIdx == 22} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img2
		}
	    } elseif {$stimIdx == 23} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 24} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 25} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img4
		} else {
		    dl_put stimdg:stimuli $i $img3
		}
	    } elseif {$stimIdx == 26} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img1
		} else {
		    dl_put stimdg:stimuli $i $img4
		}          
	    } elseif {$stimIdx == 27} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img2
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 28} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img3
		} else {
		    dl_put stimdg:stimuli $i $img4
		}
	    } elseif {$stimIdx == 29} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 30} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img5
		}
	    } elseif {$stimIdx == 31} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 32} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img7
		} else {
		    dl_put stimdg:stimuli $i $img6
		}
	    } elseif {$stimIdx == 33} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img5
		} else {
		    dl_put stimdg:stimuli $i $img7
		}
	    } elseif {$stimIdx == 34} {
		if {$imgcount == 4} {
		    dl_put stimdg:stimuli $i $img6
		} else {
		    dl_put stimdg:stimuli $i $img7
		}		
	    } elseif {$stimIdx == 5} {
		#5-6 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
		    dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 6} {
		#5-7 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img5
		    }
		}
	    } elseif {$stimIdx == 7} {
		#6-5 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 8} {
	        dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 10} {
		dl_put stimdg:stimuli $i $img5
	    } elseif {$stimIdx == 36} {
		#7-5 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img5
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 18} {
	        dl_put stimdg:stimuli $i $img6
	    } elseif {$stimIdx == 19} {
	        dl_put stimdg:stimuli $i $img7
	    } elseif {$stimIdx == 20} {
	        dl_put stimdg:stimuli $i $img7		
	    } elseif {$stimIdx == 35} {
		#6-7 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img7
		    } else {
			dl_put stimdg:stimuli $i $img6
		    }
		}
	    } elseif {$stimIdx == 37} {
		#7-6 pair
		if {[dl_get $reps $i] == 2} {
		    if {$imgcount == 2} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		} elseif {[dl_get $reps $i] == 6} {
		    if {$imgcount == 6} {
			dl_put stimdg:stimuli $i $img6
		    } else {
			dl_put stimdg:stimuli $i $img7
		    }
		}
	    } elseif {$stimIdx == 12} {
	        dl_put stimdg:stimuli $i $img5
		
	    } elseif {$stimIdx == 13} {
		dl_put stimdg:stimuli $i $img5
        
	    } elseif {$stimIdx == 14} {
		dl_put stimdg:stimuli $i $img6
	               
	    } elseif {$stimIdx == 15} {
		dl_put stimdg:stimuli $i $img6
		
	    } elseif {$stimIdx == 16} {
		dl_put stimdg:stimuli $i $img7
		       
	    } elseif {$stimIdx == 17} {
		dl_put stimdg:stimuli $i $img7
		      
	    } elseif {$stimIdx == 0} {
		dl_put stimdg:stimuli $i "fixation"
	    }
        
	    set imgcount [expr $imgcount+1]

	    if {$i < [expr [dl_llength stimdg:stim_types]-1]} {
        
		if {[dl_get stimdg:stim_types $i] != [dl_get stimdg:stim_types [expr $i+1]]} {
		    set imgcount 1
		}
	    }
	}; #End of for loop assigning imgs
    }; #End of if else statement for block_order selection
    # Once have the basics of stimdg, want the on and off time of every line
    set ntrials [dl_llength stimdg:block_id]

    # Figure out how long each frame is based on refresh rate
    # FrameDuration ;# gives answer in *ms*
    set screenHz [screen_set RefreshRate] ;# frames/sec
    # For debugging in tcl
    #set screenHz 60

    
    # Reward
    # ------
    # Grab rewardDuration from the (quick)params
    # set reward_amount 250
    # dl_set stimdg:rewardDuration [dl_repeat $reward_amount $ntrials]

    dl_set stimdg:rwdInt_max [dl_repeat $rwdInt_max $ntrials]
    dl_set stimdg:rwdInt_min [dl_repeat $rwdInt_min $ntrials]
    dl_set stimdg:rwdInt_inc [dl_repeat $rwdInt_inc $ntrials]
    dl_set stimdg:rwdInt_n [dl_repeat $rwdInt_n $ntrials]

    # Want the fixation spot present for all the trials
    dl_set stimdg:fixPresent [dl_repeat $fixPresent $ntrials]
    dl_set stimdg:background_luminance [dl_repeat $bgLuminance $ntrials]

    # Fixwin setting
    # -----
    #Not necessary for this protocol, but left the option there in case we choose to use it. 
    #dl_set stimdg:fixwinRadius [dl_repeat $fixwin_radius $ntrials]

    # Times (obj_loc)
    # -----

    # Loop through all the "trials"
    # Assign start and stop times, in seconds, for each line
    # Initialize the colums for times
    #   Initialize to a decimal otherwise get an error when try to assign
    dl_set stimdg:onSec [dl_repeat 0.1 $ntrials]
    dl_set stimdg:offSec [dl_repeat 0.1 $ntrials]
    # Initialize the columns for frame numbers (always integers)
    dl_set stimdg:onFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:offFrameN [dl_repeat 0 $ntrials]
    dl_set stimdg:endFrameN [dl_repeat 0 $ntrials]

    #Now add in the column that has the stimulus ITI info
    #First load in the table containing the ITI columns
    
    dg_read mri/Scan_seq/habit_itis/habit_only_itis.dgz

    ######## This will be made so that it chooses randomly from 20 columns of time.
    set col [dl_pickone [dl_fromto 0 20]]
    dl_local unused_cols \
	[dl_not [dl_oneof [dl_fromto 0 20] $col]]
    set col_2 [dl_pickone [dl_select [dl_fromto 0 20] $unused_cols]]
    ######### This is still not correct. Need to fix. NYR 11/20/2019
    set iti_vals [dl_select habit_only_itis:$col [dl_fromto 0 [dl_llength stimdg:block_n]]]
    set stimOffDur $iti_vals
    
    for { set i 0 } { $i < $ntrials } { incr i } {
	# Have a choice, can either caluculate the times and attempt
	#  to get the frames right, or can calculate the frames, and 
	#  calculate the times accordingly.
	# This is frame-based

	#onSec
	#-----
	if {$i == 0} {
	    # First trial
	    #dl_put stimdg:onSec $i 0
	    dl_put stimdg:onFrameN $i 0
	} else {
	    # previous block type
	    set prev_block_type [lindex [dl_tcllist stimdg:block_type] \
				     [expr $i - 1]]
	    
	    # Set the frames, by prev block type
	    if { $prev_block_type == "fixation" } {
		set prevOffFrames 0

	    } else {
		# round because frames must be integers
		set prevOffFrames [expr round([dl_get $stimOffDur $i] * $screenHz)]
	    }

	    #onFrameN = previous trial offFrame + 
	    #           prevOffFrames (duration in frames)
	    dl_put stimdg:onFrameN $i \
		[expr [lindex [dl_tcllist stimdg:offFrameN] [expr $i - 1]] \
		     + $prevOffFrames]

	    # Also set the previous end frame. 
	    #  Repeats info, but keeps the iti explicit
	    dl_put stimdg:endFrameN [expr $i - 1] \
		[dl_get stimdg:onFrameN $i]
	}
	# Calculate the corresponding on time in seconds
	dl_put stimdg:onSec $i \
	    [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
		 / ($screenHz + 0.0)] ;#intro floating point

	#offSec
	#------
	# Get the current block type, fixation or otherwise
	set block_type [lindex [dl_tcllist stimdg:block_type] $i] 

	# Set the frames, by block type (note != not equal)
	#  round because frames must be integers
	if { $block_type == "fixation" } {
	    set currOnFrames [expr round($fixBlockDur * $screenHz)]
	    
	} else {
	    # Not fixation
	    set currOnFrames [expr round($stimOnDur * $screenHz)]
	}
	
	# offFrameN = onFrameN + currOnFrames (dur in frames)
	dl_put stimdg:offFrameN $i \
	    [expr [lindex [dl_tcllist stimdg:onFrameN] $i] \
		 + $currOnFrames]
	
	# Calculate the corresponding off time in seconds
	dl_put stimdg:offSec $i \
	    [expr [lindex [dl_tcllist stimdg:offFrameN] $i] \
		 / ($screenHz + 0.0)] ;#intro floating point
	
	set lasttrial [dl_last $ntrials]

	### Fixed so that last frame and endframe match
	
	if {$i == [expr $lasttrial-1] } {
	    dl_put stimdg:endFrameN $i [dl_last stimdg:offFrameN]
	}
	
    } ;#end trial loop
    dl_set stimdg:ITIs $stimOffDur
    # For debugging
    #return stimdg
    if { [dl_oneof [dl_eq stimdg:stimcountlist 7] 1] == 1 } { error "fatal seq repeat, pick again" }
    dl_set stimdg:test [dl_eq stimdg:stimcountlist 7]
    dl_set stimdg:test_2 [dl_find [dl_eq stimdg:stimcountlist 5] 1]
    if { [dl_sum [dl_find [dl_eq stimdg:stimcountlist 7] 1]] >= 1 } { error "fatal seq repeat, pick again" }
    
};#end proc habit_only_doubled

proc erase_combs {nerase combo_list stim_used raw_combo_list} {
    #Procedure called by stim picker to erase invalid combinations of stimuli should they occur
    #want to get the indices of the last five items that were filled in that are not 20 
    set nerase_range [dl_select $combo_list [dl_noteq $combo_list 20]]
    set nerase_idxs [dl_series [expr [dl_find [dl_lastPos $nerase_range] 1]-$nerase]]\
			 [dl_find [dl_lastPos $nerase_range] 1]]
    set combs_to_erase [dl_select $combo_list $nerase_idxs]
    #For each of the combs to erase, find it in the raw list and used list and
    #put it back
    for {set i 0} {$i < [dl_length $combs_to_erase]} {incr i} {
	set eidx [dl_findAll [dl_and [dl_eq $stim_used 1] [dl_eq $raw_combo_list\
							    [dl_get $combs_to_erase $i]]] 1]
	dl_put $stim_used $eidx 0
    }
    #Take the erased ones off the original combo_list
    set combo_list [dl_replaceByIndex $combo_list $nerase_idxs 20]
    set g [dg_create]
    dl_set $g:combo_list $combo_list
    dl_set $g:stim_used $stim_used
    return $g 
}; #end of erase_combs



} ;#end namespace
