# FILE: base@24point.tcl
# AUTHOR: stimgui.tcl
# DATE: Tue Aug 26 4:29:53 PM EDT 2003
# DESCRIPTION: this is an autogenerated base file
# USAGE: The array 'base' contains all the information.
#        Each argument to the loader_function will have an
#        entry within the array base indexed by its own name.
#        The value of that array entry is the choices for the
#        combo box in stimgui.  Each choice is within its own
#        list.  Each of these lists is of length 1 (if the
#        value of the list is displayed and passed) or 2 
#        then the passed value is the first element and the
#        second element is what is displayed in the combo
#        box in stimgui options frame.

###################### Local Variables ######################

################### Base Array Definition ###################

 pack [button $stimgui::widgets(OptionsFrame).process \
    	  -text {Process calib data} \
	   -command {
	       if { [catch { ::stimgui::stimCmd {set last_datafile} } lastfile] } {
		   MessageDlg .message -title "Calibration" \
		       -type ok -message "No previous datafile found" -parent .
	       } else {
		   # convert the datafile
		   set script l:/projects/stimulator2/emcalib/calib2/scripts/do_calibration.tcl
		   exec wish85.exe $script $lastfile $stimgui::QNXHost &
	       }
	   }]

array unset base
array set base {
    incr {
        { 6.0 }
        { 7.0 }
	{ 3.5 }
   }
    fix_size {
        { 4 }
        { 3 }
        { 2 }
        { 1 }
	{ 7 }
   }
}
