#
# FILE
#   calib_variants.tcl
#
# PROTOCOL
#   emcalib/calib2
#
# DESCRIPTION
#   This file defines the specific variants displayed by stimgui, the loader proc
#     defined in {protocol}_loaders.tcl file, the shortname for default init and destroy
#     files, and the description displayed by stimgui.
#
# AUTHOR
#   DLS
#
# LAST MODIFIED
#  3/13
#

namespace eval calib2 {
    # ---------------------------------------------------------------------
    # Variant Definitions
    # format { {display name} {loader proc}
    #          {shortname for defaults,init,destroy} {display description} }
    set variants { 
	{ {9 point } setup_9point {9point} {Calib with 9 points} }
	{ {9 point spinning } setup_9point_spin {9point} {Calib with 9 points} }
	{ {9 point darker} setup_9point {9point_darker} {Calib with 9 points} }
    }

    # ---------------------------------------------------------------------
    # Default init and destroy procs (copy and edit to make variant specific)
    proc default_init { } {
	setBackground 125 125 125
#	load polygon[info sharedlibextension]
#	load metagroup[info sharedlibextension]
	set ::cur_namespace [namespace current]
    }
    proc default_destroy { } {
 	# nothing to do
    }
    
    # ---------------------------------------------------------------------
    # Variant specific init and destroy procs (must occur as a set!)
    
    proc 9point_init { } {
	setBackground 120 120 120
#	load /shared/qpcs/stim/stimdlls/polygon[info sharedlibextension]
#	load /shared/qpcs/stim/stimdlls/metagroup[info sharedlibextension]
	set ::cur_namespace [namespace current]
    }
    proc 9point_destroy { } {
 	# nothing to do
    }
    
    proc 9point_darker_init { } {
	setBackground 60 60 60
	#	load polygon[info sharedlibextension]
#	load metagroup[info sharedlibextension]
	set ::cur_namespace [namespace current]
    }
    proc 9point_darker_destroy { } {
 	# nothing to do
    }

    # ---------------------------------------------------------------------
    # Shared Procs

}
