#
# PROTOCOL
#   emcalib/calib2
#
# DESCRIPTION
#   Define calibration protocol for emcalib task
#
# AUTHOR
#   DLS
#

namespace eval calib2 {
    proc prot_init { } {
	# just get the stimcmds ready
	stimcmds
    }
    proc prot_destroy { } {
	# nothing to do for now
    }

    proc describe {} {
	return "Estimate calibration parameters for eye tracker"
    }

    proc stimcmds {} {
	namespace inscope :: {
	    proc fixon {} { 
		glistSetVisible 1; redraw 
	    }

	    proc fixoff {} {
		glistSetVisible 0; redraw; 
		translateObj $::fixspot 0 0 
	    }

	    proc fixposition { x y } { 
		translateObj $::fixspot $x $y; redraw 
	    }

	    proc nexttrial {} {
		global fixspot
		glistInit 1
		resetObjList

		set nstims [dl_length stimdg:remaining]
		if { [dl_sum stimdg:remaining] == 0 } {
		    return "-1 $nstims $nstims"
		}
		set curstim [dl_pickone [dl_select stimdg:id stimdg:remaining]]

		# Background color
		if { [dl_exists stimdg:background_r] } {
		    set background_r [dl_get stimdg:background_r $curstim]
		    set background_g [dl_get stimdg:background_g $curstim]
		    set background_b [dl_get stimdg:background_b $curstim]
		    setBackground $background_r $background_g $background_b
		}

		set type [dl_get stimdg:type $curstim]
		set fixspot [make_fixspot $type]
		scaleObj $fixspot [dl_get stimdg:scale $curstim]

		glistAddObject $fixspot 0
		if { $type == "spinning" } {
		    glistSetDynamic 0 1
		} else {
		    glistSetDynamic 0 0
		}
		
		set ${::cur_namespace}::curstim $curstim
		return "$curstim [dl_get stimdg:jump_x $curstim] \
	                [dl_get stimdg:jump_y $curstim] \
	                [dl_sum [dl_not stimdg:remaining]] \
	                $nstims"
	    }

	    proc make_fixspot { type } {
		if { $type == "bullseye" } {
		    set obj [metagroup]

		    set circ [polygon]
#		    polytexcoords $circ "0. 0. 1. 1." "0. 1. 0. 1."
		    polycirc $circ 1
		    scaleObj $circ 1.0
		    polycolor $circ 0.7 0.7 0.0
		    metagroupAdd $obj $circ

		    set circ [polygon]
#		    polytexcoords $circ "0. 0. 1. 1." "0. 1. 0. 1."
		    polycirc $circ 1
		    scaleObj $circ 0.20
		    polycolor $circ 0.0 0.0 0.0
		    metagroupAdd $obj $circ
		} else {
		    set obj [polygon]
		    polyverts $obj "-.5 -.5 .5 .5 -.5" "-.5 .5 .5 -.5 -.5"
		    polycolor $obj .75 .75 0
		    addPreScript $obj "spinSpot $obj"
		}
		return $obj
	    }
	    
	    proc spinSpot { obj } {
		set cycletime 1000
		set t [expr 1.*($::StimTicks%$cycletime)]
		set spin [expr 360.*($t/$cycletime)]
		rotateObj $obj $spin 0 0 1
	    }

	    proc reset {} {
		glistSetVisible 0; redraw;
		dl_set stimdg:remaining [dl_ones [dl_length stimdg:remaining]]
	    }
	    
	    proc endtrial { status } {
		if { $status } {
		    dl_put stimdg:remaining [set ${::cur_namespace}::curstim] 0
		}
		return
	    }
	}
    }
}


