#
# NAME
#   emcalib.tcl
#
# DESCRIPTION
#   Emcalib Stimulator Definition File
#
# AUTHOR
#   DLS
#

namespace eval ::emcalib {
    proc sys_init { } {
	# nothing special yet
    }
    proc sys_destroy { } {
	# nothing to do
    }

    #######################################################################
    # default_stimcmds
    #   defines all the procedures that are called by the state system.
    #   each of these procedures can (and many should) be overwritten in
    #   the {protocol}.tcl file.
    #   these provide defaults for the state system dependent stimcmds that
    #   will be inherited by each protocol unless they are overwritten in
    #   {protocol}.tcl
    proc default_stimcmds { } {
	namespace inscope :: {
	    # reset:
	    #    Description:
	    #       clears the screen and resets the stimdg
	    proc reset { } {
		glistSetVisible 0; redraw;
		dl_set stimdg:remaining [dl_ones [dl_length stimdg:remaining]]
	    }

	    # fixon:
	    #    Description:
	    #       draws the fixspot
	    proc fixon {} {
		glistSetCurGroup 0; glistSetVisible 1; redraw;
		dout .....1.. 
	    }

	    # fixjump <x> <y>:
	    #    Description:
	    #       move fixspot to (<x>,<y>)
	    proc fixjump {} {
	    }

	    # fixoff:
	    #    Description:
	    #       removes fixspot from screen (leaves it clear)
	    proc fixoff {} {
		glistSetVisible 0; redraw; 
		dout .....0.. 
	    }
	    # clearscreen:
	    #    Description:
	    #       clears the screen
	    proc clearscreen { } {
		glistSetVisible 0; redraw;
	    }
	    # nexttrial:
	    #    Description:
	    #       chooses the upcomming trial's stim id form those remaining
	    #       loads all relevent information for the upcomming trial
	    #    Return:
	    #       if there are no more trials remaining.  block finished.
	    #          -1 $nstims $nstims
	    #       else   
	    #          id jump_x jump_y remaining_trials total_trials
	    proc nexttrial {} {
		return "-1 0 0"
	    }
	    # endtrial <status>:
	    #    Description:
	    #       determine, given the status of trial, if it should be 
	    #       removed from remaining trials for the current block.
	    #       By default, the trial will be removed if it was 'wrong'
	    proc endtrial { status } {
	    }

	    # subjectinfo:
	    #    Description:
	    #       can override subject info string for data file naming
	    proc subjectinfo { subj } {
		return
	    }

	    # datafileinfo:
	    #    Description:
	    #       can override filename info string for data file naming
	    proc datafileinfo { } {
		return
	    }
	    
	}
    }    

    set rmt_cmds { 
	{endtrial {%d status}}
	fixoff
	fixon
	{fixposition %f %f}
	nexttrial
	{opendata %s}
	reset
    }

}



